/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.transport.ProtocolVersion;

public interface Terms {
    public static final List UNSET_LIST = new AbstractList(){

        @Override
        public Object get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public void addFunctionsTo(List<Function> var1);

    public void collectMarkerSpecification(VariableSpecifications var1);

    public List<Term.Terminal> bind(QueryOptions var1);

    public List<ByteBuffer> bindAndGet(QueryOptions var1);

    public static Terms ofListMarker(final Lists.Marker marker, final AbstractType<?> type) {
        return new Terms(){

            @Override
            public void addFunctionsTo(List<Function> functions) {
            }

            @Override
            public void collectMarkerSpecification(VariableSpecifications boundNames) {
                marker.collectMarkerSpecification(boundNames);
            }

            @Override
            public List<ByteBuffer> bindAndGet(QueryOptions options) {
                Term.Terminal terminal = marker.bind(options);
                if (terminal == null) {
                    return null;
                }
                if (terminal == Constants.UNSET_VALUE) {
                    return UNSET_LIST;
                }
                return ((Term.MultiItemTerminal)terminal).getElements();
            }

            @Override
            public List<Term.Terminal> bind(QueryOptions options) {
                Term.Terminal terminal = marker.bind(options);
                if (terminal == null) {
                    return null;
                }
                if (terminal == Constants.UNSET_VALUE) {
                    return UNSET_LIST;
                }
                java.util.function.Function<ByteBuffer, Term.Terminal> deserializer = this.deserializer(options.getProtocolVersion());
                List<ByteBuffer> boundValues = ((Term.MultiItemTerminal)terminal).getElements();
                ArrayList<Term.Terminal> values = new ArrayList<Term.Terminal>(boundValues.size());
                int m = boundValues.size();
                for (int i = 0; i < m; ++i) {
                    ByteBuffer buffer = boundValues.get(i);
                    Term.Terminal value = buffer == null ? null : deserializer.apply(buffer);
                    values.add(value);
                }
                return values;
            }

            public java.util.function.Function<ByteBuffer, Term.Terminal> deserializer(ProtocolVersion version) {
                if (type.isCollection()) {
                    switch (((CollectionType)type).kind) {
                        case LIST: {
                            return e -> Lists.Value.fromSerialized(e, (ListType)type, version);
                        }
                        case SET: {
                            return e -> Sets.Value.fromSerialized(e, (SetType)type, version);
                        }
                        case MAP: {
                            return e -> Maps.Value.fromSerialized(e, (MapType)type, version);
                        }
                    }
                    throw new AssertionError();
                }
                return e -> new Constants.Value((ByteBuffer)e);
            }
        };
    }

    public static Terms of(final Term term) {
        return new Terms(){

            @Override
            public void addFunctionsTo(List<Function> functions) {
                term.addFunctionsTo(functions);
            }

            @Override
            public void collectMarkerSpecification(VariableSpecifications boundNames) {
                term.collectMarkerSpecification(boundNames);
            }

            @Override
            public List<ByteBuffer> bindAndGet(QueryOptions options) {
                return Collections.singletonList(term.bindAndGet(options));
            }

            @Override
            public List<Term.Terminal> bind(QueryOptions options) {
                return Collections.singletonList(term.bind(options));
            }
        };
    }

    public static Terms of(final List<Term> terms) {
        return new Terms(){

            @Override
            public void addFunctionsTo(List<Function> functions) {
                Terms.addFunctions(terms, functions);
            }

            @Override
            public void collectMarkerSpecification(VariableSpecifications boundNames) {
                int m = terms.size();
                for (int i = 0; i < m; ++i) {
                    Term term = (Term)terms.get(i);
                    term.collectMarkerSpecification(boundNames);
                }
            }

            @Override
            public List<Term.Terminal> bind(QueryOptions options) {
                int size = terms.size();
                ArrayList<Term.Terminal> terminals = new ArrayList<Term.Terminal>(size);
                for (int i = 0; i < size; ++i) {
                    Term term = (Term)terms.get(i);
                    terminals.add(term.bind(options));
                }
                return terminals;
            }

            @Override
            public List<ByteBuffer> bindAndGet(QueryOptions options) {
                int size = terms.size();
                ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(size);
                for (int i = 0; i < size; ++i) {
                    Term term = (Term)terms.get(i);
                    buffers.add(term.bindAndGet(options));
                }
                return buffers;
            }
        };
    }

    public static void addFunctions(Iterable<Term> terms, List<Function> functions) {
        for (Term term : terms) {
            if (term == null) continue;
            term.addFunctionsTo(functions);
        }
    }

    public static ByteBuffer asBytes(String keyspace, String term, AbstractType type) {
        ColumnSpecification receiver = new ColumnSpecification(keyspace, "--dummy--", new ColumnIdentifier("(dummy)", true), type);
        Term.Raw rawTerm = CQLFragmentParser.parseAny(CqlParser::term, term, "CQL term");
        return rawTerm.prepare(keyspace, receiver).bindAndGet(QueryOptions.DEFAULT);
    }
}

