/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import org.apache.cassandra.concurrent.DebuggableTask;
import org.apache.cassandra.concurrent.ExecutorFactory;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.LocalAwareExecutorPlus;
import org.apache.cassandra.concurrent.SEPExecutor;
import org.apache.cassandra.concurrent.SEPWorker;
import org.apache.cassandra.utils.Clock;

public class SharedExecutorPool {
    public static final SharedExecutorPool SHARED = new SharedExecutorPool("SharedPool");
    final ThreadGroup threadGroup;
    final AtomicLong workerId = new AtomicLong();
    public final List<SEPExecutor> executors = new CopyOnWriteArrayList<SEPExecutor>();
    final AtomicInteger spinningCount = new AtomicInteger();
    final AtomicLong stopCheck = new AtomicLong();
    final ConcurrentSkipListMap<Long, SEPWorker> spinning = new ConcurrentSkipListMap();
    final ConcurrentSkipListMap<Long, SEPWorker> descheduled = new ConcurrentSkipListMap();
    private final Set<SEPWorker> allWorkers = Collections.newSetFromMap(new ConcurrentHashMap());
    volatile boolean shuttingDown = false;

    public SharedExecutorPool(String name) {
        this(ExecutorFactory.Global.executorFactory().newThreadGroup(name));
    }

    public SharedExecutorPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    void schedule(SEPWorker.Work work) {
        Map.Entry<Long, SEPWorker> e;
        while (null != (e = this.spinning.pollFirstEntry()) || null != (e = this.descheduled.pollFirstEntry())) {
            if (!e.getValue().assign(work, false)) continue;
            return;
        }
        if (!work.isStop()) {
            SEPWorker worker = new SEPWorker(this.threadGroup, this.workerId.incrementAndGet(), work, this);
            this.allWorkers.add(worker);
        }
    }

    void workerEnded(SEPWorker worker) {
        this.allWorkers.remove(worker);
    }

    public List<DebuggableTask.RunningDebuggableTask> runningTasks() {
        return this.allWorkers.stream().map(worker -> new DebuggableTask.RunningDebuggableTask(worker.toString(), worker.currentDebuggableTask())).filter(DebuggableTask.RunningDebuggableTask::hasTask).collect(Collectors.toList());
    }

    void maybeStartSpinningWorker() {
        int current = this.spinningCount.get();
        if (current == 0 && this.spinningCount.compareAndSet(0, 1)) {
            this.schedule(SEPWorker.Work.SPINNING);
        }
    }

    public synchronized LocalAwareExecutorPlus newExecutor(int maxConcurrency, String jmxPath, String name) {
        return this.newExecutor(maxConcurrency, i -> {}, jmxPath, name);
    }

    public LocalAwareExecutorPlus newExecutor(int maxConcurrency, ExecutorPlus.MaximumPoolSizeListener maximumPoolSizeListener, String jmxPath, String name) {
        SEPExecutor executor = new SEPExecutor(this, maxConcurrency, maximumPoolSizeListener, jmxPath, name);
        this.executors.add(executor);
        return executor;
    }

    public synchronized void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.shuttingDown = true;
        for (SEPExecutor executor : this.executors) {
            executor.shutdownNow();
        }
        this.terminateWorkers();
        long until = Clock.Global.nanoTime() + unit.toNanos(timeout);
        for (SEPExecutor executor : this.executors) {
            executor.shutdown.await(until - Clock.Global.nanoTime(), TimeUnit.NANOSECONDS);
            if (executor.isTerminated()) continue;
            throw new TimeoutException(executor.name + " not terminated");
        }
    }

    void terminateWorkers() {
        Map.Entry<Long, SEPWorker> e;
        assert (this.shuttingDown);
        while (null != (e = this.descheduled.pollFirstEntry())) {
            e.getValue().assign(SEPWorker.Work.SPINNING, false);
        }
        while (null != (e = this.spinning.pollFirstEntry())) {
            LockSupport.unpark(e.getValue().thread);
        }
    }
}

