/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.audit.AuditLogEntry;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.diag.DiagnosticEvent;
import org.apache.cassandra.diag.DiagnosticEventService;

public final class AuditEvent
extends DiagnosticEvent {
    private final AuditLogEntry entry;

    private AuditEvent(AuditLogEntry entry) {
        this.entry = entry;
    }

    static void create(AuditLogEntry entry) {
        if (AuditEvent.isEnabled(entry.getType())) {
            DiagnosticEventService.instance().publish(new AuditEvent(entry));
        }
    }

    private static boolean isEnabled(AuditLogEntryType type) {
        return DiagnosticEventService.instance().isEnabled(AuditEvent.class, type);
    }

    @Override
    public Enum<?> getType() {
        return this.entry.getType();
    }

    public String getSource() {
        return this.entry.getSource().toString(true);
    }

    public AuditLogEntry getEntry() {
        return this.entry;
    }

    @Override
    public Map<String, Serializable> toMap() {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        if (this.entry.getKeyspace() != null) {
            ret.put("keyspace", (Serializable)((Object)this.entry.getKeyspace()));
        }
        if (this.entry.getOperation() != null) {
            ret.put("operation", (Serializable)((Object)this.entry.getOperation()));
        }
        if (this.entry.getScope() != null) {
            ret.put("scope", (Serializable)((Object)this.entry.getScope()));
        }
        if (this.entry.getUser() != null) {
            ret.put("user", (Serializable)((Object)this.entry.getUser()));
        }
        return ret;
    }
}

