/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.Iterator;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.util.NetUtils;
import org.apache.flink.util.Preconditions;

public class PortRange {
    private final String portRange;
    private final Iterator<Integer> portsIterator;

    public PortRange(int port) {
        this(String.valueOf(port));
    }

    public PortRange(String portRange) {
        this.portRange = (String)Preconditions.checkNotNull((Object)portRange);
        try {
            this.portsIterator = NetUtils.getPortRangeFromString((String)portRange);
        }
        catch (NumberFormatException e) {
            throw new IllegalConfigurationException("Invalid port range: \"" + portRange + "\"");
        }
    }

    public Iterator<Integer> getPortsIterator() {
        return this.portsIterator;
    }

    public String toString() {
        return this.portRange;
    }
}

