/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.AbstractStateBackend;
import org.apache.flink.runtime.state.BackendBuildingException;
import org.apache.flink.runtime.state.CheckpointStorageAccess;
import org.apache.flink.runtime.state.ConfigurableStateBackend;
import org.apache.flink.runtime.state.DefaultOperatorStateBackendBuilder;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.state.filesystem.AbstractFileStateBackend;
import org.apache.flink.runtime.state.heap.HeapKeyedStateBackendBuilder;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSetFactory;
import org.apache.flink.runtime.state.memory.MemoryBackendCheckpointStorageAccess;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;

@Deprecated
@PublicEvolving
public class MemoryStateBackend
extends AbstractFileStateBackend
implements ConfigurableStateBackend {
    private static final long serialVersionUID = 4109305377809414635L;
    public static final int DEFAULT_MAX_STATE_SIZE = 0x500000;
    private final int maxStateSize;
    private TernaryBoolean createCheckpointSubDirs = TernaryBoolean.UNDEFINED;

    public MemoryStateBackend() {
        this(null, null, 0x500000, TernaryBoolean.UNDEFINED);
    }

    public MemoryStateBackend(boolean asynchronousSnapshots) {
        this(null, null, 0x500000, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public MemoryStateBackend(int maxStateSize) {
        this(null, null, maxStateSize, TernaryBoolean.UNDEFINED);
    }

    public MemoryStateBackend(int maxStateSize, boolean asynchronousSnapshots) {
        this(null, null, maxStateSize, TernaryBoolean.fromBoolean((boolean)asynchronousSnapshots));
    }

    public MemoryStateBackend(@Nullable String checkpointPath, @Nullable String savepointPath) {
        this(checkpointPath, savepointPath, 0x500000, TernaryBoolean.UNDEFINED);
    }

    public MemoryStateBackend(@Nullable String checkpointPath, @Nullable String savepointPath, int maxStateSize, TernaryBoolean asynchronousSnapshots) {
        super(checkpointPath == null ? null : new Path(checkpointPath), savepointPath == null ? null : new Path(savepointPath));
        Preconditions.checkArgument((maxStateSize > 0 ? 1 : 0) != 0, (Object)"maxStateSize must be > 0");
        this.maxStateSize = maxStateSize;
    }

    private MemoryStateBackend(MemoryStateBackend original, ReadableConfig configuration, ClassLoader classLoader) {
        super(original.getCheckpointPath(), original.getSavepointPath(), configuration);
        this.maxStateSize = original.maxStateSize;
        this.latencyTrackingConfigBuilder = original.latencyTrackingConfigBuilder.configure(configuration);
        this.createCheckpointSubDirs = original.createCheckpointSubDirs.resolveUndefined(((Boolean)configuration.get(CheckpointingOptions.CREATE_CHECKPOINT_SUB_DIR)).booleanValue());
    }

    public int getMaxStateSize() {
        return this.maxStateSize;
    }

    public boolean isUsingAsynchronousSnapshots() {
        return true;
    }

    @Override
    public boolean supportsNoClaimRestoreMode() {
        return true;
    }

    @Override
    public boolean supportsSavepointFormat(SavepointFormatType formatType) {
        return true;
    }

    @Override
    public MemoryStateBackend configure(ReadableConfig config, ClassLoader classLoader) {
        return new MemoryStateBackend(this, config, classLoader);
    }

    @Override
    public CheckpointStorageAccess createCheckpointStorage(JobID jobId) throws IOException {
        return new MemoryBackendCheckpointStorageAccess(jobId, this.getCheckpointPath(), this.getSavepointPath(), this.createCheckpointSubDirs.getOrDefault(((Boolean)CheckpointingOptions.CREATE_CHECKPOINT_SUB_DIR.defaultValue()).booleanValue()), this.maxStateSize);
    }

    @Override
    public OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters parameters) throws Exception {
        return new DefaultOperatorStateBackendBuilder(parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getEnv().getExecutionConfig(), this.isUsingAsynchronousSnapshots(), parameters.getStateHandles(), parameters.getCancelStreamRegistry()).build();
    }

    @Override
    public <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> parameters) throws BackendBuildingException {
        TaskStateManager taskStateManager = parameters.getEnv().getTaskStateManager();
        HeapPriorityQueueSetFactory priorityQueueSetFactory = new HeapPriorityQueueSetFactory(parameters.getKeyGroupRange(), parameters.getNumberOfKeyGroups(), 128);
        LatencyTrackingStateConfig latencyTrackingStateConfig = this.latencyTrackingConfigBuilder.setMetricGroup(parameters.getMetricGroup()).build();
        return new HeapKeyedStateBackendBuilder<K>(parameters.getKvStateRegistry(), parameters.getKeySerializer(), parameters.getEnv().getUserCodeClassLoader().asClassLoader(), parameters.getNumberOfKeyGroups(), parameters.getKeyGroupRange(), parameters.getEnv().getExecutionConfig(), parameters.getTtlTimeProvider(), latencyTrackingStateConfig, parameters.getStateHandles(), AbstractStateBackend.getCompressionDecorator(parameters.getEnv().getExecutionConfig()), taskStateManager.createLocalRecoveryConfig(), priorityQueueSetFactory, this.isUsingAsynchronousSnapshots(), parameters.getCancelStreamRegistry()).build();
    }

    public String toString() {
        return "MemoryStateBackend (data in heap memory / checkpoints to JobManager) (checkpoints: '" + this.getCheckpointPath() + "', savepoints: '" + this.getSavepointPath() + ", maxStateSize: " + this.maxStateSize + ")";
    }
}

