/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;

@PublicEvolving
public abstract class AbstractStateBackend
implements StateBackend,
Serializable {
    private static final long serialVersionUID = 4620415814639230247L;
    protected LatencyTrackingStateConfig.Builder latencyTrackingConfigBuilder = LatencyTrackingStateConfig.newBuilder();

    public static StreamCompressionDecorator getCompressionDecorator(ExecutionConfig executionConfig) {
        if (executionConfig != null && executionConfig.isUseSnapshotCompression()) {
            return SnappyStreamCompressionDecorator.INSTANCE;
        }
        return UncompressedStreamCompressionDecorator.INSTANCE;
    }

    public abstract <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(StateBackend.KeyedStateBackendParameters<K> var1) throws IOException;

    @Override
    public abstract OperatorStateBackend createOperatorStateBackend(StateBackend.OperatorStateBackendParameters var1) throws Exception;
}

