/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.stopwithsavepoint;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.CheckpointScheduling;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.scheduler.SchedulerNG;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointStoppingException;
import org.apache.flink.runtime.scheduler.stopwithsavepoint.StopWithSavepointTerminationHandler;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;

public class StopWithSavepointTerminationHandlerImpl
implements StopWithSavepointTerminationHandler {
    private final Logger log;
    private final SchedulerNG scheduler;
    private final CheckpointScheduling checkpointScheduling;
    private final JobID jobId;
    private final CompletableFuture<String> result = new CompletableFuture();
    private State state = new WaitingForSavepoint();

    public <S extends SchedulerNG & CheckpointScheduling> StopWithSavepointTerminationHandlerImpl(JobID jobId, S schedulerWithCheckpointing, Logger log) {
        this(jobId, schedulerWithCheckpointing, schedulerWithCheckpointing, log);
    }

    @VisibleForTesting
    StopWithSavepointTerminationHandlerImpl(JobID jobId, SchedulerNG scheduler, CheckpointScheduling checkpointScheduling, Logger log) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.scheduler = (SchedulerNG)Preconditions.checkNotNull((Object)scheduler);
        this.checkpointScheduling = (CheckpointScheduling)Preconditions.checkNotNull((Object)checkpointScheduling);
        this.log = (Logger)Preconditions.checkNotNull((Object)log);
    }

    @Override
    public CompletableFuture<String> getSavepointPath() {
        return this.result;
    }

    @Override
    public void handleSavepointCreation(CompletedCheckpoint completedSavepoint, Throwable throwable) {
        if (throwable != null) {
            Preconditions.checkArgument((completedSavepoint == null ? 1 : 0) != 0, (Object)"No savepoint should be provided if a throwable is passed.");
            this.handleSavepointCreationFailure(throwable);
        } else {
            this.handleSavepointCreationSuccess((CompletedCheckpoint)Preconditions.checkNotNull((Object)completedSavepoint));
        }
    }

    @Override
    public void handleExecutionsTermination(Collection<ExecutionState> terminatedExecutionStates) {
        Set<ExecutionState> notFinishedExecutionStates = ((Collection)Preconditions.checkNotNull(terminatedExecutionStates)).stream().filter(state -> state != ExecutionState.FINISHED).collect(Collectors.toSet());
        if (notFinishedExecutionStates.isEmpty()) {
            this.handleExecutionsFinished();
        } else {
            this.handleAnyExecutionNotFinished(notFinishedExecutionStates);
        }
    }

    private void handleSavepointCreationSuccess(CompletedCheckpoint completedCheckpoint) {
        State oldState = this.state;
        this.state = this.state.onSavepointCreation(completedCheckpoint);
        this.log.debug("Stop-with-savepoint transitioned from {} to {} on savepoint creation handling for job {}.", new Object[]{oldState.getName(), this.state.getName(), this.jobId});
    }

    private void handleSavepointCreationFailure(Throwable throwable) {
        State oldState = this.state;
        this.state = this.state.onSavepointCreationFailure(throwable);
        this.log.debug("Stop-with-savepoint transitioned from {} to {} on savepoint creation failure handling for job {}.", new Object[]{oldState.getName(), this.state.getName(), this.jobId});
    }

    private void handleExecutionsFinished() {
        State oldState = this.state;
        this.state = this.state.onExecutionsFinished();
        this.log.debug("Stop-with-savepoint transitioned from {} to {} on execution termination handling with all executions being finished for job {}.", new Object[]{oldState.getName(), this.state.getName(), this.jobId});
    }

    private void handleAnyExecutionNotFinished(Set<ExecutionState> notFinishedExecutionStates) {
        State oldState = this.state;
        this.state = this.state.onAnyExecutionNotFinished(notFinishedExecutionStates);
        this.log.warn("Stop-with-savepoint transitioned from {} to {} on execution termination handling for job {} with some executions being in an not-finished state: {}", new Object[]{oldState.getName(), this.state.getName(), this.jobId, notFinishedExecutionStates});
    }

    private void terminateExceptionallyWithGlobalFailover(Iterable<ExecutionState> unfinishedExecutionStates, String savepointPath) {
        StopWithSavepointStoppingException inconsistentFinalStateException = new StopWithSavepointStoppingException(savepointPath, this.jobId);
        this.log.warn("Inconsistent execution state after stopping with savepoint. At least one execution is still in one of the following states: {}.", (Object)StringUtils.join(unfinishedExecutionStates, (String)", "), (Object)inconsistentFinalStateException);
        this.scheduler.handleGlobalFailure((Throwable)((Object)inconsistentFinalStateException));
        this.result.completeExceptionally((Throwable)((Object)inconsistentFinalStateException));
    }

    private void terminateExceptionally(Throwable throwable) {
        this.checkpointScheduling.startCheckpointScheduler();
        this.result.completeExceptionally(throwable);
    }

    private void terminateSuccessfully(CompletedCheckpoint completedSavepoint) {
        this.result.complete(completedSavepoint.getExternalPointer());
    }

    private static interface State {
        default public State onSavepointCreation(CompletedCheckpoint completedSavepoint) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " state does not support onSavepointCreation.");
        }

        default public State onSavepointCreationFailure(Throwable throwable) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " state does not support onSavepointCreationFailure.");
        }

        default public State onExecutionsFinished() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " state does not support onExecutionsFinished.");
        }

        default public State onAnyExecutionNotFinished(Iterable<ExecutionState> notFinishedExecutionStates) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " state does not support onAnyExecutionNotFinished.");
        }

        default public String getName() {
            return this.getClass().getSimpleName();
        }
    }

    private static final class FinalState
    implements State {
        private FinalState() {
        }

        @Override
        public State onExecutionsFinished() {
            return this;
        }

        @Override
        public State onAnyExecutionNotFinished(Iterable<ExecutionState> notFinishedExecutionStates) {
            return this;
        }
    }

    private final class SavepointCreated
    implements State {
        private final CompletedCheckpoint completedSavepoint;

        private SavepointCreated(CompletedCheckpoint completedSavepoint) {
            this.completedSavepoint = completedSavepoint;
        }

        @Override
        public State onExecutionsFinished() {
            StopWithSavepointTerminationHandlerImpl.this.terminateSuccessfully(this.completedSavepoint);
            return new FinalState();
        }

        @Override
        public State onAnyExecutionNotFinished(Iterable<ExecutionState> notFinishedExecutionStates) {
            StopWithSavepointTerminationHandlerImpl.this.terminateExceptionallyWithGlobalFailover(notFinishedExecutionStates, this.completedSavepoint.getExternalPointer());
            return new FinalState();
        }
    }

    private final class WaitingForSavepoint
    implements State {
        private WaitingForSavepoint() {
        }

        @Override
        public State onSavepointCreation(CompletedCheckpoint completedSavepoint) {
            return new SavepointCreated(completedSavepoint);
        }

        @Override
        public State onSavepointCreationFailure(Throwable throwable) {
            StopWithSavepointTerminationHandlerImpl.this.terminateExceptionally(throwable);
            return new FinalState();
        }
    }
}

