/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.rest.handler.AbstractRestHandler;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricFetcher;
import org.apache.flink.runtime.rest.handler.legacy.metrics.MetricStore;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexBackPressureInfo;
import org.apache.flink.runtime.rest.messages.JobVertexIdPathParameter;
import org.apache.flink.runtime.rest.messages.JobVertexMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobVertexBackPressureHandler
extends AbstractRestHandler<RestfulGateway, EmptyRequestBody, JobVertexBackPressureInfo, JobVertexMessageParameters> {
    private final MetricFetcher metricFetcher;

    public JobVertexBackPressureHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobVertexBackPressureInfo, JobVertexMessageParameters> messageHeaders, MetricFetcher metricFetcher) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders);
        this.metricFetcher = metricFetcher;
    }

    @Override
    protected CompletableFuture<JobVertexBackPressureInfo> handleRequest(@Nonnull HandlerRequest<EmptyRequestBody> request, @Nonnull RestfulGateway gateway) throws RestHandlerException {
        this.metricFetcher.update();
        JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
        JobVertexID jobVertexId = (JobVertexID)request.getPathParameter(JobVertexIdPathParameter.class);
        MetricStore.TaskMetricStore taskMetricStore = this.metricFetcher.getMetricStore().getTaskMetricStore(jobId.toString(), jobVertexId.toString());
        Map<String, Map<Integer, Integer>> jobRepresentativeExecutions = this.metricFetcher.getMetricStore().getRepresentativeAttempts().get(jobId.toString());
        Map<Integer, Integer> representativeAttempts = jobRepresentativeExecutions != null ? jobRepresentativeExecutions.get(jobVertexId.toString()) : null;
        return CompletableFuture.completedFuture(taskMetricStore != null ? this.createJobVertexBackPressureInfo(taskMetricStore, representativeAttempts) : JobVertexBackPressureInfo.deprecated());
    }

    private JobVertexBackPressureInfo createJobVertexBackPressureInfo(MetricStore.TaskMetricStore taskMetricStore, Map<Integer, Integer> representativeAttempts) {
        List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> subtaskBackPressureInfos = this.createSubtaskBackPressureInfo(taskMetricStore, representativeAttempts);
        return new JobVertexBackPressureInfo(JobVertexBackPressureInfo.VertexBackPressureStatus.OK, JobVertexBackPressureHandler.getBackPressureLevel(this.getMaxBackPressureRatio(subtaskBackPressureInfos)), this.metricFetcher.getLastUpdateTime(), subtaskBackPressureInfos);
    }

    private List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> createSubtaskBackPressureInfo(MetricStore.TaskMetricStore taskMetricStore, Map<Integer, Integer> representativeAttempts) {
        Map<Integer, MetricStore.SubtaskMetricStore> subtaskMetricStores = taskMetricStore.getAllSubtaskMetricStores();
        ArrayList<JobVertexBackPressureInfo.SubtaskBackPressureInfo> result = new ArrayList<JobVertexBackPressureInfo.SubtaskBackPressureInfo>(subtaskMetricStores.size());
        for (Map.Entry<Integer, MetricStore.SubtaskMetricStore> entry : subtaskMetricStores.entrySet()) {
            int representativeAttempt;
            int subtaskIndex = entry.getKey();
            MetricStore.SubtaskMetricStore subtaskMetricStore = entry.getValue();
            Map<Integer, MetricStore.ComponentMetricStore> allAttemptsMetricStores = subtaskMetricStore.getAllAttemptsMetricStores();
            if (allAttemptsMetricStores.isEmpty() || allAttemptsMetricStores.size() == 1) {
                result.add(this.createSubtaskAttemptBackpressureInfo(subtaskIndex, null, subtaskMetricStore, null));
                continue;
            }
            int n = representativeAttempt = representativeAttempts == null ? -1 : representativeAttempts.getOrDefault(subtaskIndex, -1);
            if (!allAttemptsMetricStores.containsKey(representativeAttempt)) {
                representativeAttempt = allAttemptsMetricStores.keySet().iterator().next();
            }
            ArrayList<JobVertexBackPressureInfo.SubtaskBackPressureInfo> otherConcurrentAttempts = new ArrayList<JobVertexBackPressureInfo.SubtaskBackPressureInfo>(allAttemptsMetricStores.size() - 1);
            for (Map.Entry<Integer, MetricStore.ComponentMetricStore> attemptStore : allAttemptsMetricStores.entrySet()) {
                if (attemptStore.getKey() == representativeAttempt) continue;
                otherConcurrentAttempts.add(this.createSubtaskAttemptBackpressureInfo(subtaskIndex, attemptStore.getKey(), attemptStore.getValue(), null));
            }
            result.add(this.createSubtaskAttemptBackpressureInfo(subtaskIndex, representativeAttempt, allAttemptsMetricStores.get(representativeAttempt), otherConcurrentAttempts));
        }
        result.sort(Comparator.comparingInt(JobVertexBackPressureInfo.SubtaskBackPressureInfo::getSubtask));
        return result;
    }

    private JobVertexBackPressureInfo.SubtaskBackPressureInfo createSubtaskAttemptBackpressureInfo(int subtaskIndex, @Nullable Integer attemptNumber, MetricStore.ComponentMetricStore metricStore, @Nullable List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> otherConcurrentAttempts) {
        double backPressureRatio = this.getBackPressureRatio(metricStore);
        double idleRatio = this.getIdleRatio(metricStore);
        double busyRatio = this.getBusyRatio(metricStore);
        return new JobVertexBackPressureInfo.SubtaskBackPressureInfo(subtaskIndex, attemptNumber, JobVertexBackPressureHandler.getBackPressureLevel(backPressureRatio), backPressureRatio, idleRatio, busyRatio, otherConcurrentAttempts);
    }

    private double getMaxBackPressureRatio(List<JobVertexBackPressureInfo.SubtaskBackPressureInfo> subtaskBackPressureInfos) {
        return subtaskBackPressureInfos.stream().mapToDouble(backPressureInfo -> backPressureInfo.getBackPressuredRatio()).max().getAsDouble();
    }

    private double getBackPressureRatio(MetricStore.ComponentMetricStore metricStore) {
        return this.getMsPerSecondMetricAsRatio(metricStore, "backPressuredTimeMsPerSecond");
    }

    private double getIdleRatio(MetricStore.ComponentMetricStore metricStore) {
        return this.getMsPerSecondMetricAsRatio(metricStore, "idleTimeMsPerSecond");
    }

    private double getBusyRatio(MetricStore.ComponentMetricStore metricStore) {
        return this.getMsPerSecondMetricAsRatio(metricStore, "busyTimeMsPerSecond");
    }

    private double getMsPerSecondMetricAsRatio(MetricStore.ComponentMetricStore metricStore, String metricName) {
        return Double.valueOf(metricStore.getMetric(metricName, "0")) / 1000.0;
    }

    private static JobVertexBackPressureInfo.VertexBackPressureLevel getBackPressureLevel(double backPressureRatio) {
        if (backPressureRatio <= 0.1) {
            return JobVertexBackPressureInfo.VertexBackPressureLevel.OK;
        }
        if (backPressureRatio <= 0.5) {
            return JobVertexBackPressureInfo.VertexBackPressureLevel.LOW;
        }
        return JobVertexBackPressureInfo.VertexBackPressureLevel.HIGH;
    }
}

