/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.ArchivedExecutionConfig;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.job.AbstractAccessExecutionGraphHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobConfigInfo;
import org.apache.flink.runtime.rest.messages.JobMessageParameters;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.OnlyExecutionGraphJsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class JobConfigHandler
extends AbstractAccessExecutionGraphHandler<JobConfigInfo, JobMessageParameters>
implements OnlyExecutionGraphJsonArchivist {
    public JobConfigHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, JobConfigInfo, JobMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected JobConfigInfo handleRequest(HandlerRequest<EmptyRequestBody> request, AccessExecutionGraph executionGraph) {
        return JobConfigHandler.createJobConfigInfo(executionGraph);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        JobConfigInfo json = JobConfigHandler.createJobConfigInfo(graph);
        String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString());
        return Collections.singleton(new ArchivedJson(path, json));
    }

    private static JobConfigInfo createJobConfigInfo(AccessExecutionGraph executionGraph) {
        ArchivedExecutionConfig executionConfig = executionGraph.getArchivedExecutionConfig();
        JobConfigInfo.ExecutionConfigInfo executionConfigInfo = executionConfig != null ? JobConfigInfo.ExecutionConfigInfo.from(executionConfig) : null;
        return new JobConfigInfo(executionGraph.getJobID(), executionGraph.getJobName(), executionConfigInfo);
    }
}

