/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.resettable;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.memory.MemoryAllocationException;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.operators.resettable.NonReusingBlockResettableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReusingBlockResettableIterator<T>
extends NonReusingBlockResettableIterator<T> {
    public static final Logger LOG = LoggerFactory.getLogger(ReusingBlockResettableIterator.class);
    private final T reuseElement;

    public ReusingBlockResettableIterator(MemoryManager memoryManager, Iterator<T> input, TypeSerializer<T> serializer, int numPages, AbstractInvokable ownerTask) throws MemoryAllocationException {
        this(memoryManager, serializer, numPages, ownerTask);
        this.input = input;
    }

    public ReusingBlockResettableIterator(MemoryManager memoryManager, TypeSerializer<T> serializer, int numPages, AbstractInvokable ownerTask) throws MemoryAllocationException {
        super(memoryManager, serializer, numPages, ownerTask);
        this.reuseElement = serializer.createInstance();
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.nextElement == null) {
                if (this.readPhase) {
                    T tmp = this.getNextRecord(this.reuseElement);
                    if (tmp != null) {
                        this.nextElement = tmp;
                        return true;
                    }
                    return false;
                }
                if (this.input.hasNext()) {
                    Object next = this.input.next();
                    if (this.writeNextRecord(next)) {
                        this.nextElement = next;
                        return true;
                    }
                    this.leftOverElement = next;
                    return false;
                }
                this.noMoreBlocks = true;
                return false;
            }
            return true;
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error (de)serializing record in block resettable iterator.", ioex);
        }
    }
}

