/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.blocklist.BlockedTaskManagerChecker;
import org.apache.flink.runtime.jobmaster.slotpool.BlocklistDeclarativeSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.DefaultAllocatedSlotPool;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.util.Preconditions;

public class BlocklistDeclarativeSlotPoolFactory
implements DeclarativeSlotPoolFactory {
    private final BlockedTaskManagerChecker blockedTaskManagerChecker;

    public BlocklistDeclarativeSlotPoolFactory(BlockedTaskManagerChecker blockedTaskManagerChecker) {
        this.blockedTaskManagerChecker = (BlockedTaskManagerChecker)Preconditions.checkNotNull((Object)blockedTaskManagerChecker);
    }

    @Override
    public DeclarativeSlotPool create(JobID jobId, Consumer<? super Collection<ResourceRequirement>> notifyNewResourceRequirements, Time idleSlotTimeout, Time rpcTimeout) {
        return new BlocklistDeclarativeSlotPool(jobId, new DefaultAllocatedSlotPool(), notifyNewResourceRequirements, this.blockedTaskManagerChecker, idleSlotTimeout, rpcTimeout);
    }
}

