/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobmaster.AllocatedSlotInfo;
import org.apache.flink.util.Preconditions;

public class AllocatedSlotReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final JobID jobId;
    private final Collection<AllocatedSlotInfo> allocatedSlotInfos;

    public AllocatedSlotReport(JobID jobId, Collection<AllocatedSlotInfo> allocatedSlotInfos) {
        this.jobId = (JobID)Preconditions.checkNotNull((Object)jobId);
        this.allocatedSlotInfos = (Collection)Preconditions.checkNotNull(allocatedSlotInfos);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public Collection<AllocatedSlotInfo> getAllocatedSlotInfos() {
        return Collections.unmodifiableCollection(this.allocatedSlotInfos);
    }

    public String toString() {
        return "AllocatedSlotReport{jobId=" + this.jobId + ", allocatedSlotInfos=" + this.allocatedSlotInfos + '}';
    }
}

