/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class SlotSharingGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<JobVertexID> ids = new TreeSet<JobVertexID>();
    private final SlotSharingGroupId slotSharingGroupId = new SlotSharingGroupId();
    private ResourceProfile resourceProfile = ResourceProfile.UNKNOWN;

    public void addVertexToGroup(JobVertexID id) {
        this.ids.add((JobVertexID)Preconditions.checkNotNull((Object)id));
    }

    public void removeVertexFromGroup(JobVertexID id) {
        this.ids.remove(Preconditions.checkNotNull((Object)id));
    }

    public Set<JobVertexID> getJobVertexIds() {
        return Collections.unmodifiableSet(this.ids);
    }

    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    public void setResourceProfile(ResourceProfile resourceProfile) {
        this.resourceProfile = (ResourceProfile)Preconditions.checkNotNull((Object)resourceProfile);
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public String toString() {
        return "SlotSharingGroup " + this.ids.toString();
    }
}

