/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.BufferWithSubpartition;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.BufferAccumulator;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageSortBuffer;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.TriConsumer;

public class SortBufferAccumulator
implements BufferAccumulator {
    private final int numSubpartitions;
    private final int numBuffers;
    private final int bufferSizeBytes;
    private final LinkedList<MemorySegment> freeSegments = new LinkedList();
    private final TieredStorageMemoryManager memoryManager;
    private final boolean isPartialRecordAllowed;
    @Nullable
    private TieredStorageSortBuffer currentDataBuffer;
    @Nullable
    private BufferRecycler bufferRecycler;
    @Nullable
    private TriConsumer<TieredStorageSubpartitionId, Buffer, Integer> accumulatedBufferFlusher;
    private boolean isBroadcastDataBuffer;

    public SortBufferAccumulator(int numSubpartitions, int numBuffers, int bufferSizeBytes, TieredStorageMemoryManager memoryManager, boolean isPartialRecordAllowed) {
        this.numSubpartitions = numSubpartitions;
        this.bufferSizeBytes = bufferSizeBytes;
        this.numBuffers = numBuffers;
        this.memoryManager = memoryManager;
        this.isPartialRecordAllowed = isPartialRecordAllowed;
    }

    @Override
    public void setup(TriConsumer<TieredStorageSubpartitionId, Buffer, Integer> bufferFlusher) {
        this.accumulatedBufferFlusher = bufferFlusher;
    }

    @Override
    public void receive(ByteBuffer record, TieredStorageSubpartitionId subpartitionId, Buffer.DataType dataType, boolean isBroadcast) throws IOException {
        int targetSubpartition = subpartitionId.getSubpartitionId();
        this.switchCurrentDataBufferIfNeeded(isBroadcast);
        if (!((TieredStorageSortBuffer)Preconditions.checkNotNull((Object)this.currentDataBuffer)).append(record, targetSubpartition, dataType)) {
            return;
        }
        if (!this.currentDataBuffer.hasRemaining()) {
            this.currentDataBuffer.release();
            this.writeLargeRecord(record, targetSubpartition, dataType);
            return;
        }
        this.flushDataBuffer();
        Preconditions.checkState((boolean)record.hasRemaining(), (Object)"Empty record.");
        this.receive(record, subpartitionId, dataType, isBroadcast);
    }

    @Override
    public void close() {
        this.flushCurrentDataBuffer();
        this.releaseFreeBuffers();
        if (this.currentDataBuffer != null) {
            this.currentDataBuffer.release();
        }
    }

    private void switchCurrentDataBufferIfNeeded(boolean isBroadcast) {
        if (isBroadcast == this.isBroadcastDataBuffer && this.currentDataBuffer != null && !this.currentDataBuffer.isReleased() && !this.currentDataBuffer.isFinished()) {
            return;
        }
        this.isBroadcastDataBuffer = isBroadcast;
        this.flushCurrentDataBuffer();
        this.currentDataBuffer = this.createNewDataBuffer();
    }

    private TieredStorageSortBuffer createNewDataBuffer() {
        this.requestBuffers();
        int numBuffersForSort = this.freeSegments.size() / 2;
        return new TieredStorageSortBuffer(this.freeSegments, this::recycleBuffer, this.numSubpartitions, this.bufferSizeBytes, numBuffersForSort, this.isPartialRecordAllowed);
    }

    private void requestBuffers() {
        while (this.freeSegments.size() < this.numBuffers) {
            Buffer buffer = this.requestBuffer();
            this.freeSegments.add(((Buffer)Preconditions.checkNotNull((Object)buffer)).getMemorySegment());
            if (this.bufferRecycler != null) continue;
            this.bufferRecycler = buffer.getRecycler();
        }
    }

    private void flushDataBuffer() {
        MemorySegment freeSegment;
        BufferWithSubpartition bufferWithSubpartition;
        if (this.currentDataBuffer == null || this.currentDataBuffer.isReleased() || !this.currentDataBuffer.hasRemaining()) {
            return;
        }
        this.currentDataBuffer.finish();
        while ((bufferWithSubpartition = this.currentDataBuffer.getNextBuffer(freeSegment = this.getFreeSegment())) != null) {
            int numRemainingConsecutiveBuffers = (int)Math.ceil((double)this.currentDataBuffer.getRecordRemainingBytes() / (double)this.bufferSizeBytes);
            this.flushBuffer(bufferWithSubpartition, numRemainingConsecutiveBuffers);
        }
        this.releaseFreeBuffers();
        this.currentDataBuffer.release();
    }

    private void flushCurrentDataBuffer() {
        if (this.currentDataBuffer != null) {
            this.flushDataBuffer();
            this.currentDataBuffer = null;
        }
    }

    private void writeLargeRecord(ByteBuffer record, int subpartitionId, Buffer.DataType dataType) {
        Preconditions.checkState((dataType != Buffer.DataType.EVENT_BUFFER ? 1 : 0) != 0);
        while (record.hasRemaining()) {
            int toCopy = Math.min(record.remaining(), this.bufferSizeBytes);
            MemorySegment writeBuffer = this.requestBuffer().getMemorySegment();
            writeBuffer.put(0, record, toCopy);
            int numRemainingConsecutiveBuffers = (int)Math.ceil((double)record.remaining() / (double)this.bufferSizeBytes);
            if (numRemainingConsecutiveBuffers == 0) {
                dataType = Buffer.DataType.DATA_BUFFER_WITH_CLEAR_END;
            }
            this.flushBuffer(new BufferWithSubpartition(new NetworkBuffer(writeBuffer, (BufferRecycler)Preconditions.checkNotNull((Object)this.bufferRecycler), dataType, toCopy), subpartitionId), numRemainingConsecutiveBuffers);
        }
        this.releaseFreeBuffers();
    }

    private MemorySegment getFreeSegment() {
        MemorySegment freeSegment = this.freeSegments.poll();
        if (freeSegment == null) {
            freeSegment = this.requestBuffer().getMemorySegment();
        }
        return freeSegment;
    }

    private void flushBuffer(BufferWithSubpartition bufferWithSubpartition, int numRemainingConsecutiveBuffers) {
        ((TriConsumer)Preconditions.checkNotNull(this.accumulatedBufferFlusher)).accept((Object)new TieredStorageSubpartitionId(bufferWithSubpartition.getSubpartitionIndex()), (Object)bufferWithSubpartition.getBuffer(), (Object)numRemainingConsecutiveBuffers);
    }

    private Buffer requestBuffer() {
        BufferBuilder bufferBuilder = this.memoryManager.requestBufferBlocking(this);
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumerFromBeginning();
        Buffer buffer = bufferConsumer.build();
        bufferBuilder.close();
        bufferConsumer.close();
        return buffer;
    }

    private void releaseFreeBuffers() {
        this.freeSegments.forEach(this::recycleBuffer);
        this.freeSegments.clear();
    }

    private void recycleBuffer(MemorySegment memorySegment) {
        ((BufferRecycler)Preconditions.checkNotNull((Object)this.bufferRecycler)).recycle(memorySegment);
    }
}

