/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.NetworkSequenceViewReader;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.netty.NettyPartitionRequestListener;
import org.apache.flink.runtime.io.network.netty.PartitionRequestQueue;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.PartitionRequestListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionProvider;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionIndexSet;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.util.Preconditions;

class CreditBasedSequenceNumberingViewReader
implements BufferAvailabilityListener,
NetworkSequenceViewReader {
    private final Object requestLock = new Object();
    private final InputChannelID receiverId;
    private final PartitionRequestQueue requestQueue;
    private final int initialCredit;
    private int subpartitionId;
    private volatile ResultSubpartitionView subpartitionView;
    private volatile PartitionRequestListener partitionRequestListener;
    private boolean isRegisteredAsAvailable = false;
    private int numCreditsAvailable;

    CreditBasedSequenceNumberingViewReader(InputChannelID receiverId, int initialCredit, PartitionRequestQueue requestQueue) {
        Preconditions.checkArgument((initialCredit >= 0 ? 1 : 0) != 0, (Object)"Must be non-negative.");
        this.receiverId = receiverId;
        this.initialCredit = initialCredit;
        this.numCreditsAvailable = initialCredit;
        this.requestQueue = requestQueue;
        this.subpartitionId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSubpartitionViewOrRegisterListener(ResultPartitionProvider partitionProvider, ResultPartitionID resultPartitionId, ResultSubpartitionIndexSet subpartitionIndexSet) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((this.subpartitionView == null ? 1 : 0) != 0, (Object)"Subpartitions already requested");
            Preconditions.checkState((this.partitionRequestListener == null ? 1 : 0) != 0, (Object)"Partition request listener already created");
            this.partitionRequestListener = new NettyPartitionRequestListener(partitionProvider, this, subpartitionIndexSet, resultPartitionId);
            Optional<ResultSubpartitionView> subpartitionViewOptional = partitionProvider.createSubpartitionViewOrRegisterListener(resultPartitionId, subpartitionIndexSet, this, this.partitionRequestListener);
            if (subpartitionViewOptional.isPresent()) {
                this.subpartitionView = subpartitionViewOptional.get();
                if (subpartitionIndexSet.size() == 1) {
                    this.subpartitionId = subpartitionIndexSet.values().iterator().next();
                }
            } else {
                return;
            }
        }
        this.notifyDataAvailable(this.subpartitionView);
        this.requestQueue.notifyReaderCreated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifySubpartitionsCreated(ResultPartition partition, ResultSubpartitionIndexSet subpartitionIndexSet) throws IOException {
        Object object = this.requestLock;
        synchronized (object) {
            Preconditions.checkState((this.subpartitionView == null ? 1 : 0) != 0, (Object)"Subpartitions already requested");
            this.subpartitionView = partition.createSubpartitionView(subpartitionIndexSet, (BufferAvailabilityListener)this);
            if (subpartitionIndexSet.size() == 1) {
                this.subpartitionId = subpartitionIndexSet.values().iterator().next();
            }
        }
        this.notifyDataAvailable(this.subpartitionView);
        this.requestQueue.notifyReaderCreated(this);
    }

    @Override
    public void addCredit(int creditDeltas) {
        this.numCreditsAvailable += creditDeltas;
    }

    @Override
    public void notifyRequiredSegmentId(int subpartitionId, int segmentId) {
        this.subpartitionView.notifyRequiredSegmentId(subpartitionId, segmentId);
    }

    @Override
    public void resumeConsumption() {
        if (this.initialCredit == 0) {
            this.numCreditsAvailable = 0;
        }
        this.subpartitionView.resumeConsumption();
    }

    @Override
    public void acknowledgeAllRecordsProcessed() {
        this.subpartitionView.acknowledgeAllDataProcessed();
    }

    @Override
    public void setRegisteredAsAvailable(boolean isRegisteredAvailable) {
        this.isRegisteredAsAvailable = isRegisteredAvailable;
    }

    @Override
    public boolean isRegisteredAsAvailable() {
        return this.isRegisteredAsAvailable;
    }

    @Override
    public ResultSubpartitionView.AvailabilityWithBacklog getAvailabilityAndBacklog() {
        return this.subpartitionView.getAvailabilityAndBacklog(this.numCreditsAvailable > 0);
    }

    private Buffer.DataType getNextDataType(ResultSubpartition.BufferAndBacklog bufferAndBacklog) {
        Buffer.DataType nextDataType = bufferAndBacklog.getNextDataType();
        if (this.numCreditsAvailable > 0 || nextDataType.isEvent()) {
            return nextDataType;
        }
        return Buffer.DataType.NONE;
    }

    @Override
    public InputChannelID getReceiverId() {
        return this.receiverId;
    }

    @Override
    public void notifyNewBufferSize(int newBufferSize) {
        this.subpartitionView.notifyNewBufferSize(newBufferSize);
    }

    @Override
    public void notifyPartitionRequestTimeout(PartitionRequestListener partitionRequestListener) {
        this.requestQueue.notifyPartitionRequestTimeout(partitionRequestListener);
        this.partitionRequestListener = null;
    }

    @VisibleForTesting
    int getNumCreditsAvailable() {
        return this.numCreditsAvailable;
    }

    @VisibleForTesting
    ResultSubpartitionView.AvailabilityWithBacklog hasBuffersAvailable() {
        return this.subpartitionView.getAvailabilityAndBacklog(true);
    }

    @Override
    public int peekNextBufferSubpartitionId() throws IOException {
        if (this.subpartitionId >= 0) {
            return this.subpartitionId;
        }
        return this.subpartitionView.peekNextBufferSubpartitionId();
    }

    @Override
    @Nullable
    public InputChannel.BufferAndAvailability getNextBuffer() throws IOException {
        ResultSubpartition.BufferAndBacklog next = this.subpartitionView.getNextBuffer();
        if (next != null) {
            if (next.buffer().isBuffer() && --this.numCreditsAvailable < 0) {
                throw new IllegalStateException("no credit available");
            }
            Buffer.DataType nextDataType = this.getNextDataType(next);
            return new InputChannel.BufferAndAvailability(next.buffer(), nextDataType, next.buffersInBacklog(), next.getSequenceNumber());
        }
        return null;
    }

    @Override
    public boolean needAnnounceBacklog() {
        return this.initialCredit == 0 && this.numCreditsAvailable == 0;
    }

    @Override
    public boolean isReleased() {
        return this.subpartitionView.isReleased();
    }

    @Override
    public Throwable getFailureCause() {
        return this.subpartitionView.getFailureCause();
    }

    @Override
    public void releaseAllResources() throws IOException {
        if (this.partitionRequestListener != null) {
            this.partitionRequestListener.releaseListener();
        }
        this.subpartitionView.releaseAllResources();
    }

    @Override
    public void notifyDataAvailable(ResultSubpartitionView view) {
        this.requestQueue.notifyReaderNonEmpty(this);
    }

    @Override
    public void notifyPriorityEvent(int prioritySequenceNumber) {
        this.notifyDataAvailable(this.subpartitionView);
    }

    public String toString() {
        return "CreditBasedSequenceNumberingViewReader{requestLock=" + this.requestLock + ", receiverId=" + (Object)((Object)this.receiverId) + ", numCreditsAvailable=" + this.numCreditsAvailable + ", isRegisteredAsAvailable=" + this.isRegisteredAsAvailable + '}';
    }
}

