/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.client.DuplicateJobSubmissionException;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.highavailability.JobResultStore;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphStore;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.FunctionUtils;

public class SessionDispatcherLeaderProcess
extends AbstractDispatcherLeaderProcess
implements JobGraphStore.JobGraphListener {
    private final AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherGatewayServiceFactory;
    private final JobGraphStore jobGraphStore;
    private final JobResultStore jobResultStore;
    private final Executor ioExecutor;
    private CompletableFuture<Void> onGoingRecoveryOperation = FutureUtils.completedVoidFuture();

    private SessionDispatcherLeaderProcess(UUID leaderSessionId, AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherGatewayServiceFactory, JobGraphStore jobGraphStore, JobResultStore jobResultStore, Executor ioExecutor, FatalErrorHandler fatalErrorHandler) {
        super(leaderSessionId, fatalErrorHandler);
        this.dispatcherGatewayServiceFactory = dispatcherGatewayServiceFactory;
        this.jobGraphStore = jobGraphStore;
        this.jobResultStore = jobResultStore;
        this.ioExecutor = ioExecutor;
    }

    @Override
    protected void onStart() {
        this.startServices();
        this.onGoingRecoveryOperation = this.createDispatcherBasedOnRecoveredJobGraphsAndRecoveredDirtyJobResults();
    }

    private void startServices() {
        try {
            this.jobGraphStore.start(this);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(String.format("Could not start %s when trying to start the %s.", this.jobGraphStore.getClass().getSimpleName(), this.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private void createDispatcherIfRunning(Collection<JobGraph> jobGraphs, Collection<JobResult> recoveredDirtyJobResults) {
        this.runIfStateIs(AbstractDispatcherLeaderProcess.State.RUNNING, () -> this.createDispatcher(jobGraphs, recoveredDirtyJobResults));
    }

    private void createDispatcher(Collection<JobGraph> jobGraphs, Collection<JobResult> recoveredDirtyJobResults) {
        AbstractDispatcherLeaderProcess.DispatcherGatewayService dispatcherService = this.dispatcherGatewayServiceFactory.create(DispatcherId.fromUuid(this.getLeaderSessionId()), jobGraphs, recoveredDirtyJobResults, this.jobGraphStore, this.jobResultStore);
        this.completeDispatcherSetup(dispatcherService);
    }

    private CompletableFuture<Void> createDispatcherBasedOnRecoveredJobGraphsAndRecoveredDirtyJobResults() {
        CompletableFuture<Collection> dirtyJobsFuture = CompletableFuture.supplyAsync(this::getDirtyJobResultsIfRunning, this.ioExecutor);
        return ((CompletableFuture)((CompletableFuture)dirtyJobsFuture.thenApplyAsync(dirtyJobs -> this.recoverJobsIfRunning(dirtyJobs.stream().map(JobResult::getJobId).collect(Collectors.toSet())), this.ioExecutor)).thenAcceptBoth(dirtyJobsFuture, this::createDispatcherIfRunning)).handle(this::onErrorIfRunning);
    }

    private Collection<JobGraph> recoverJobsIfRunning(Set<JobID> recoveredDirtyJobResults) {
        return this.supplyUnsynchronizedIfRunning(() -> this.recoverJobs(recoveredDirtyJobResults)).orElse(Collections.emptyList());
    }

    private Collection<JobGraph> recoverJobs(Set<JobID> recoveredDirtyJobResults) {
        this.log.info("Recover all persisted job graphs that are not finished, yet.");
        Collection<JobID> jobIds = this.getJobIds();
        ArrayList<JobGraph> recoveredJobGraphs = new ArrayList<JobGraph>();
        for (JobID jobId : jobIds) {
            if (!recoveredDirtyJobResults.contains(jobId)) {
                this.tryRecoverJob(jobId).ifPresent(recoveredJobGraphs::add);
                continue;
            }
            this.log.info("Skipping recovery of a job with job id {}, because it already reached a globally terminal state", (Object)jobId);
        }
        this.log.info("Successfully recovered {} persisted job graphs.", (Object)recoveredJobGraphs.size());
        return recoveredJobGraphs;
    }

    private Collection<JobID> getJobIds() {
        try {
            return this.jobGraphStore.getJobIds();
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Could not retrieve job ids of persisted jobs.", (Throwable)e);
        }
    }

    private Optional<JobGraph> tryRecoverJob(JobID jobId) {
        this.log.info("Trying to recover job with job id {}.", (Object)jobId);
        try {
            JobGraph jobGraph = this.jobGraphStore.recoverJobGraph(jobId);
            if (jobGraph == null) {
                this.log.info("Skipping recovery of job with job id {}, because it already finished in a previous execution", (Object)jobId);
            }
            return Optional.ofNullable(jobGraph);
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(String.format("Could not recover job with job id %s.", jobId), (Throwable)e);
        }
    }

    private Collection<JobResult> getDirtyJobResultsIfRunning() {
        return this.supplyUnsynchronizedIfRunning(this::getDirtyJobResults).orElse(Collections.emptyList());
    }

    private Collection<JobResult> getDirtyJobResults() {
        try {
            return this.jobResultStore.getDirtyResults();
        }
        catch (IOException e) {
            throw new FlinkRuntimeException("Could not retrieve JobResults of globally-terminated jobs from JobResultStore", (Throwable)e);
        }
    }

    @Override
    protected CompletableFuture<Void> onClose() {
        return CompletableFuture.runAsync(this::stopServices, this.ioExecutor);
    }

    private void stopServices() {
        try {
            this.jobGraphStore.stop();
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @Override
    public void onAddedJobGraph(JobID jobId) {
        this.runIfStateIs(AbstractDispatcherLeaderProcess.State.RUNNING, () -> this.handleAddedJobGraph(jobId));
    }

    private void handleAddedJobGraph(JobID jobId) {
        this.log.debug("Job {} has been added to the {} by another process.", (Object)jobId, (Object)this.jobGraphStore.getClass().getSimpleName());
        this.onGoingRecoveryOperation = ((CompletableFuture)((CompletableFuture)this.onGoingRecoveryOperation.thenApplyAsync(ignored -> this.recoverJobIfRunning(jobId), this.ioExecutor)).thenCompose(optionalJobGraph -> optionalJobGraph.flatMap(this::submitAddedJobIfRunning).orElse(FutureUtils.completedVoidFuture()))).handle(this::onErrorIfRunning);
    }

    private Optional<CompletableFuture<Void>> submitAddedJobIfRunning(JobGraph jobGraph) {
        return this.supplyIfRunning(() -> this.submitAddedJob(jobGraph));
    }

    private CompletableFuture<Void> submitAddedJob(JobGraph jobGraph) {
        DispatcherGateway dispatcherGateway = this.getDispatcherGatewayInternal();
        return ((CompletableFuture)dispatcherGateway.submitJob(jobGraph, RpcUtils.INF_TIMEOUT).thenApply(FunctionUtils.nullFn())).exceptionally(this::filterOutDuplicateJobSubmissionException);
    }

    private Void filterOutDuplicateJobSubmissionException(Throwable throwable) {
        Throwable strippedException = ExceptionUtils.stripCompletionException((Throwable)throwable);
        if (strippedException instanceof DuplicateJobSubmissionException) {
            DuplicateJobSubmissionException duplicateJobSubmissionException = (DuplicateJobSubmissionException)((Object)strippedException);
            this.log.debug("Ignore recovered job {} because the job is currently being executed.", (Object)duplicateJobSubmissionException.getJobID(), (Object)duplicateJobSubmissionException);
            return null;
        }
        throw new CompletionException(throwable);
    }

    private DispatcherGateway getDispatcherGatewayInternal() {
        return (DispatcherGateway)Preconditions.checkNotNull(this.getDispatcherGateway().getNow(null));
    }

    private Optional<JobGraph> recoverJobIfRunning(JobID jobId) {
        return this.supplyUnsynchronizedIfRunning(() -> this.tryRecoverJob(jobId)).flatMap(x -> x);
    }

    @Override
    public void onRemovedJobGraph(JobID jobId) {
        this.runIfStateIs(AbstractDispatcherLeaderProcess.State.RUNNING, () -> this.handleRemovedJobGraph(jobId));
    }

    private void handleRemovedJobGraph(JobID jobId) {
        this.log.debug("Job {} has been removed from the {} by another process.", (Object)jobId, (Object)this.jobGraphStore.getClass().getSimpleName());
        this.onGoingRecoveryOperation = ((CompletableFuture)this.onGoingRecoveryOperation.thenCompose(ignored -> this.removeJobGraphIfRunning(jobId).orElse(FutureUtils.completedVoidFuture()))).handle(this::onErrorIfRunning);
    }

    private Optional<CompletableFuture<Void>> removeJobGraphIfRunning(JobID jobId) {
        return this.supplyIfRunning(() -> this.removeJobGraph(jobId));
    }

    private CompletableFuture<Void> removeJobGraph(JobID jobId) {
        return this.getDispatcherService().map(dispatcherService -> dispatcherService.onRemovedJobGraph(jobId)).orElseGet(FutureUtils::completedVoidFuture);
    }

    public static SessionDispatcherLeaderProcess create(UUID leaderSessionId, AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory dispatcherFactory, JobGraphStore jobGraphStore, JobResultStore jobResultStore, Executor ioExecutor, FatalErrorHandler fatalErrorHandler) {
        return new SessionDispatcherLeaderProcess(leaderSessionId, dispatcherFactory, jobGraphStore, jobResultStore, ioExecutor, fatalErrorHandler);
    }
}

