/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.metadata;

import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.util.Disposable;
import org.apache.flink.util.Preconditions;

public class CheckpointMetadata
implements Disposable {
    private final long checkpointId;
    private final Collection<OperatorState> operatorStates;
    private final Collection<MasterState> masterStates;
    @Nullable
    private final CheckpointProperties properties;

    public CheckpointMetadata(long checkpointId, Collection<OperatorState> operatorStates, Collection<MasterState> masterStates) {
        this(checkpointId, operatorStates, masterStates, null);
    }

    public CheckpointMetadata(long checkpointId, Collection<OperatorState> operatorStates, Collection<MasterState> masterStates, @Nullable CheckpointProperties properties) {
        this.checkpointId = checkpointId;
        this.operatorStates = operatorStates;
        this.masterStates = (Collection)Preconditions.checkNotNull(masterStates, (String)"masterStates");
        this.properties = properties;
    }

    public long getCheckpointId() {
        return this.checkpointId;
    }

    public Collection<OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public Collection<MasterState> getMasterStates() {
        return this.masterStates;
    }

    public void dispose() throws Exception {
        for (OperatorState operatorState : this.operatorStates) {
            operatorState.discardState();
        }
        this.operatorStates.clear();
        this.masterStates.clear();
    }

    public String toString() {
        return "Checkpoint Metadata";
    }

    @Nullable
    public CheckpointProperties getCheckpointProperties() {
        return this.properties;
    }

    public CheckpointMetadata withProperties(CheckpointProperties properties) {
        return new CheckpointMetadata(this.checkpointId, this.operatorStates, this.masterStates, properties);
    }
}

