/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.channel.ChannelStatePendingResult;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.checkpoint.channel.SubtaskID;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.logger.NetworkActionsLogger;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class ChannelStateCheckpointWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelStateCheckpointWriter.class);
    private final DataOutputStream dataStream;
    private final CheckpointStateOutputStream checkpointStream;
    private Throwable throwable;
    private final ChannelStateSerializer serializer;
    private final long checkpointId;
    private final RunnableWithException onComplete;
    private final Set<SubtaskID> subtasksToRegister;
    private final Map<SubtaskID, ChannelStatePendingResult> pendingResults = new HashMap<SubtaskID, ChannelStatePendingResult>();

    ChannelStateCheckpointWriter(Set<SubtaskID> subtasks, long checkpointId, CheckpointStreamFactory streamFactory, ChannelStateSerializer serializer, RunnableWithException onComplete) throws Exception {
        this(subtasks, checkpointId, streamFactory.createCheckpointStateOutputStream(CheckpointedStateScope.EXCLUSIVE), serializer, onComplete);
    }

    @VisibleForTesting
    ChannelStateCheckpointWriter(Set<SubtaskID> subtasks, long checkpointId, CheckpointStateOutputStream stream, ChannelStateSerializer serializer, RunnableWithException onComplete) {
        this(subtasks, checkpointId, serializer, onComplete, stream, new DataOutputStream((OutputStream)((Object)stream)));
    }

    @VisibleForTesting
    ChannelStateCheckpointWriter(Set<SubtaskID> subtasks, long checkpointId, ChannelStateSerializer serializer, RunnableWithException onComplete, CheckpointStateOutputStream checkpointStateOutputStream, DataOutputStream dataStream) {
        Preconditions.checkArgument((!subtasks.isEmpty() ? 1 : 0) != 0, (Object)"The subtasks cannot be empty.");
        this.subtasksToRegister = new HashSet<SubtaskID>(subtasks);
        this.checkpointId = checkpointId;
        this.checkpointStream = (CheckpointStateOutputStream)((Object)Preconditions.checkNotNull((Object)((Object)checkpointStateOutputStream)));
        this.serializer = (ChannelStateSerializer)Preconditions.checkNotNull((Object)serializer);
        this.dataStream = (DataOutputStream)Preconditions.checkNotNull((Object)dataStream);
        this.onComplete = (RunnableWithException)Preconditions.checkNotNull((Object)onComplete);
        this.runWithChecks(() -> serializer.writeHeader(dataStream));
    }

    void registerSubtaskResult(SubtaskID subtaskID, ChannelStateWriter.ChannelStateWriteResult result) {
        Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (Object)"The write is done.");
        Preconditions.checkState((!this.pendingResults.containsKey(subtaskID) ? 1 : 0) != 0, (String)"The subtask %s has already been register before.", (Object[])new Object[]{subtaskID});
        this.subtasksToRegister.remove(subtaskID);
        ChannelStatePendingResult pendingResult = new ChannelStatePendingResult(subtaskID.getSubtaskIndex(), this.checkpointId, result, this.serializer);
        this.pendingResults.put(subtaskID, pendingResult);
    }

    void releaseSubtask(SubtaskID subtaskID) throws Exception {
        if (this.subtasksToRegister.remove(subtaskID)) {
            this.tryFinishResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInput(JobVertexID jobVertexID, int subtaskIndex, InputChannelInfo info, Buffer buffer) {
        try {
            if (this.isDone()) {
                return;
            }
            ChannelStatePendingResult pendingResult = this.getChannelStatePendingResult(jobVertexID, subtaskIndex);
            this.write(pendingResult.getInputChannelOffsets(), info, buffer, !pendingResult.isAllInputsReceived(), "ChannelStateCheckpointWriter#writeInput");
        }
        finally {
            buffer.recycleBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOutput(JobVertexID jobVertexID, int subtaskIndex, ResultSubpartitionInfo info, Buffer buffer) {
        try {
            if (this.isDone()) {
                return;
            }
            ChannelStatePendingResult pendingResult = this.getChannelStatePendingResult(jobVertexID, subtaskIndex);
            this.write(pendingResult.getResultSubpartitionOffsets(), info, buffer, !pendingResult.isAllOutputsReceived(), "ChannelStateCheckpointWriter#writeOutput");
        }
        finally {
            buffer.recycleBuffer();
        }
    }

    private <K> void write(Map<K, AbstractChannelStateHandle.StateContentMetaInfo> offsets, K key, Buffer buffer, boolean precondition, String action) {
        this.runWithChecks(() -> {
            Preconditions.checkState((boolean)precondition);
            long offset = this.checkpointStream.getPos();
            try (Closeable ignored = NetworkActionsLogger.measureIO(action, buffer);){
                this.serializer.writeData(this.dataStream, buffer);
            }
            long size = this.checkpointStream.getPos() - offset;
            offsets.computeIfAbsent(key, unused -> new AbstractChannelStateHandle.StateContentMetaInfo()).withDataAdded(offset, size);
            NetworkActionsLogger.tracePersist(action, buffer, key, this.checkpointId);
        });
    }

    void completeInput(JobVertexID jobVertexID, int subtaskIndex) throws Exception {
        if (this.isDone()) {
            return;
        }
        this.getChannelStatePendingResult(jobVertexID, subtaskIndex).completeInput();
        this.tryFinishResult();
    }

    void completeOutput(JobVertexID jobVertexID, int subtaskIndex) throws Exception {
        if (this.isDone()) {
            return;
        }
        this.getChannelStatePendingResult(jobVertexID, subtaskIndex).completeOutput();
        this.tryFinishResult();
    }

    public void tryFinishResult() throws Exception {
        if (!this.subtasksToRegister.isEmpty()) {
            return;
        }
        for (ChannelStatePendingResult result : this.pendingResults.values()) {
            if (result.isAllInputsReceived() && result.isAllOutputsReceived()) continue;
            return;
        }
        if (this.isDone()) {
            this.doComplete(this.onComplete);
        } else {
            this.runWithChecks(() -> this.doComplete(this.onComplete, this::finishWriteAndResult));
        }
    }

    private void finishWriteAndResult() throws IOException {
        StreamStateHandle stateHandle = null;
        if (this.checkpointStream.getPos() == this.serializer.getHeaderLength()) {
            this.dataStream.close();
        } else {
            this.dataStream.flush();
            stateHandle = this.checkpointStream.closeAndGetHandle();
        }
        for (ChannelStatePendingResult result : this.pendingResults.values()) {
            result.finishResult(stateHandle);
        }
    }

    private void doComplete(RunnableWithException ... callbacks) throws Exception {
        for (RunnableWithException callback : callbacks) {
            callback.run();
        }
    }

    public boolean isDone() {
        if (this.throwable != null) {
            return true;
        }
        for (ChannelStatePendingResult result : this.pendingResults.values()) {
            if (!result.isDone()) continue;
            return true;
        }
        return false;
    }

    private void runWithChecks(RunnableWithException r) {
        block2: {
            try {
                Preconditions.checkState((!this.isDone() ? 1 : 0) != 0, (String)"results are already completed", (Object[])new Object[]{this.pendingResults.values()});
                r.run();
            }
            catch (Exception e) {
                this.fail(e);
                if (ExceptionUtils.findThrowable((Throwable)e, IOException.class).isPresent()) break block2;
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    public void fail(JobVertexID jobVertexID, int subtaskIndex, Throwable throwable) {
        if (this.isDone()) {
            return;
        }
        this.throwable = throwable;
        ChannelStatePendingResult result = this.pendingResults.get(SubtaskID.of(jobVertexID, subtaskIndex));
        if (result != null) {
            result.fail(throwable);
        }
        this.failResultAndCloseStream(new CheckpointException(CheckpointFailureReason.CHANNEL_STATE_SHARED_STREAM_EXCEPTION, throwable));
    }

    public void fail(Throwable throwable) {
        if (this.isDone()) {
            return;
        }
        this.throwable = throwable;
        this.failResultAndCloseStream(throwable);
    }

    public void failResultAndCloseStream(Throwable e) {
        for (ChannelStatePendingResult result : this.pendingResults.values()) {
            result.fail(e);
        }
        try {
            this.checkpointStream.close();
        }
        catch (Exception closeException) {
            String message = "Unable to close checkpointStream after a failure";
            if (ExceptionUtils.findThrowable((Throwable)closeException, IOException.class).isPresent()) {
                LOG.warn(message, (Throwable)closeException);
            }
            throw new RuntimeException(message, closeException);
        }
    }

    @Nonnull
    private ChannelStatePendingResult getChannelStatePendingResult(JobVertexID jobVertexID, int subtaskIndex) {
        SubtaskID subtaskID = SubtaskID.of(jobVertexID, subtaskIndex);
        ChannelStatePendingResult pendingResult = this.pendingResults.get(subtaskID);
        Preconditions.checkNotNull((Object)pendingResult, (String)"The subtask[%s] is not registered yet", (Object[])new Object[]{subtaskID});
        return pendingResult;
    }
}

