/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.checkpoint.AbstractCompleteCheckpointStore;
import org.apache.flink.runtime.checkpoint.CheckpointStoreUtil;
import org.apache.flink.runtime.checkpoint.CheckpointSubsumeHelper;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.persistence.ResourceVersion;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompletedCheckpointStore<R extends ResourceVersion<R>>
extends AbstractCompleteCheckpointStore {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompletedCheckpointStore.class);
    private final StateHandleStore<CompletedCheckpoint, R> checkpointStateHandleStore;
    private final int maxNumberOfCheckpointsToRetain;
    private final ArrayDeque<CompletedCheckpoint> completedCheckpoints;
    private final Executor ioExecutor;
    private final CheckpointStoreUtil completedCheckpointStoreUtil;
    private final AtomicBoolean running = new AtomicBoolean(true);

    public DefaultCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain, StateHandleStore<CompletedCheckpoint, R> stateHandleStore, CheckpointStoreUtil completedCheckpointStoreUtil, Collection<CompletedCheckpoint> completedCheckpoints, SharedStateRegistry sharedStateRegistry, Executor executor) {
        super(sharedStateRegistry);
        Preconditions.checkArgument((maxNumberOfCheckpointsToRetain >= 1 ? 1 : 0) != 0, (Object)"Must retain at least one checkpoint.");
        this.maxNumberOfCheckpointsToRetain = maxNumberOfCheckpointsToRetain;
        this.checkpointStateHandleStore = (StateHandleStore)Preconditions.checkNotNull(stateHandleStore);
        this.completedCheckpoints = new ArrayDeque(maxNumberOfCheckpointsToRetain + 1);
        this.completedCheckpoints.addAll(completedCheckpoints);
        this.ioExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.completedCheckpointStoreUtil = (CheckpointStoreUtil)Preconditions.checkNotNull((Object)completedCheckpointStoreUtil);
    }

    @Override
    public boolean requiresExternalizedCheckpoints() {
        return true;
    }

    @Override
    public CompletedCheckpoint addCheckpointAndSubsumeOldestOne(CompletedCheckpoint checkpoint, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) throws Exception {
        Preconditions.checkState((boolean)this.running.get(), (Object)"Checkpoint store has already been shutdown.");
        Preconditions.checkNotNull((Object)checkpoint, (String)"Checkpoint");
        String path = this.completedCheckpointStoreUtil.checkpointIDToName(checkpoint.getCheckpointID());
        this.checkpointStateHandleStore.addAndLock(path, checkpoint);
        this.completedCheckpoints.addLast(checkpoint);
        Optional<CompletedCheckpoint> subsume = CheckpointSubsumeHelper.subsume(this.completedCheckpoints, this.maxNumberOfCheckpointsToRetain, completedCheckpoint -> {
            this.tryRemove(completedCheckpoint.getCheckpointID());
            checkpointsCleaner.addSubsumedCheckpoint(completedCheckpoint);
        });
        DefaultCompletedCheckpointStore.findLowest(this.completedCheckpoints).ifPresent(id -> checkpointsCleaner.cleanSubsumedCheckpoints((long)id, this.getSharedStateRegistry().unregisterUnusedState((long)id), postCleanup, this.ioExecutor));
        return subsume.orElse(null);
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.completedCheckpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.completedCheckpoints.size();
    }

    @Override
    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxNumberOfCheckpointsToRetain;
    }

    @Override
    public void shutdown(JobStatus jobStatus, CheckpointsCleaner checkpointsCleaner) throws Exception {
        super.shutdown(jobStatus, checkpointsCleaner);
        if (this.running.compareAndSet(true, false)) {
            if (jobStatus.isGloballyTerminalState()) {
                LOG.info("Shutting down");
                long lowestRetained = Long.MAX_VALUE;
                for (CompletedCheckpoint checkpoint : this.completedCheckpoints) {
                    try {
                        if (this.tryRemoveCompletedCheckpoint(checkpoint, checkpoint.shouldBeDiscardedOnShutdown(jobStatus), checkpointsCleaner, () -> {})) continue;
                        lowestRetained = Math.min(lowestRetained, checkpoint.getCheckpointID());
                    }
                    catch (Exception e) {
                        LOG.warn("Fail to remove checkpoint during shutdown.", (Throwable)e);
                        if (checkpoint.shouldBeDiscardedOnShutdown(jobStatus)) continue;
                        lowestRetained = Math.min(lowestRetained, checkpoint.getCheckpointID());
                    }
                }
                this.completedCheckpoints.clear();
                this.checkpointStateHandleStore.clearEntries();
                checkpointsCleaner.cleanSubsumedCheckpoints(lowestRetained, this.getSharedStateRegistry().unregisterUnusedState(lowestRetained), () -> {}, this.ioExecutor);
            } else {
                LOG.info("Suspending");
                this.completedCheckpoints.clear();
                this.checkpointStateHandleStore.releaseAll();
            }
        }
    }

    private boolean tryRemoveCompletedCheckpoint(CompletedCheckpoint completedCheckpoint, boolean shouldDiscard, CheckpointsCleaner checkpointsCleaner, Runnable postCleanup) throws Exception {
        if (this.tryRemove(completedCheckpoint.getCheckpointID())) {
            checkpointsCleaner.cleanCheckpoint(completedCheckpoint, shouldDiscard, postCleanup, this.ioExecutor);
            return shouldDiscard;
        }
        return shouldDiscard;
    }

    private boolean tryRemove(long checkpointId) throws Exception {
        return this.checkpointStateHandleStore.releaseAndTryRemove(this.completedCheckpointStoreUtil.checkpointIDToName(checkpointId));
    }
}

