/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStats;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStatsSummarySnapshot;
import org.apache.flink.runtime.checkpoint.StatsSummary;
import org.apache.flink.util.Preconditions;

public class CompletedCheckpointStatsSummary
implements Serializable {
    private static final long serialVersionUID = 5784360461635814038L;
    private static final int HISTOGRAM_WINDOW_SIZE = 10000;
    private final StatsSummary stateSize;
    private final StatsSummary checkpointedSize;
    private final StatsSummary duration;
    private final StatsSummary processedData;
    private final StatsSummary persistedData;

    CompletedCheckpointStatsSummary() {
        this(new StatsSummary(10000), new StatsSummary(10000), new StatsSummary(10000), new StatsSummary(10000), new StatsSummary(10000));
    }

    private CompletedCheckpointStatsSummary(StatsSummary stateSize, StatsSummary checkpointedSize, StatsSummary duration, StatsSummary processedData, StatsSummary persistedData) {
        this.stateSize = (StatsSummary)Preconditions.checkNotNull((Object)stateSize);
        this.checkpointedSize = (StatsSummary)Preconditions.checkNotNull((Object)checkpointedSize);
        this.duration = (StatsSummary)Preconditions.checkNotNull((Object)duration);
        this.processedData = (StatsSummary)Preconditions.checkNotNull((Object)processedData);
        this.persistedData = (StatsSummary)Preconditions.checkNotNull((Object)persistedData);
    }

    void updateSummary(CompletedCheckpointStats completed) {
        this.stateSize.add(completed.getStateSize());
        this.checkpointedSize.add(completed.getCheckpointedSize());
        this.duration.add(completed.getEndToEndDuration());
        this.processedData.add(completed.getProcessedData());
        this.persistedData.add(completed.getPersistedData());
    }

    CompletedCheckpointStatsSummarySnapshot createSnapshot() {
        return new CompletedCheckpointStatsSummarySnapshot(this.duration.createSnapshot(), this.processedData.createSnapshot(), this.persistedData.createSnapshot(), this.stateSize.createSnapshot(), this.checkpointedSize.createSnapshot());
    }

    public StatsSummary getStateSizeStats() {
        return this.stateSize;
    }

    public StatsSummary getEndToEndDurationStats() {
        return this.duration;
    }

    public StatsSummary getProcessedDataStats() {
        return this.processedData;
    }

    public StatsSummary getPersistedDataStats() {
        return this.persistedData;
    }
}

