/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;

final class BlobInputStream
extends InputStream {
    private final InputStream wrappedInputStream;
    private final OutputStream wrappedOutputStream;
    private final BlobKey blobKey;
    private final int bytesToReceive;
    private final MessageDigest md;
    private int bytesReceived;

    BlobInputStream(InputStream wrappedInputStream, BlobKey blobKey, OutputStream wrappedOutputStream) throws IOException {
        this.wrappedInputStream = wrappedInputStream;
        this.blobKey = blobKey;
        this.wrappedOutputStream = wrappedOutputStream;
        this.bytesToReceive = BlobUtils.readLength(wrappedInputStream);
        if (this.bytesToReceive < 0) {
            throw new FileNotFoundException();
        }
        this.md = blobKey != null ? BlobUtils.createMessageDigest() : null;
    }

    private void throwEOFException() throws EOFException {
        throw new EOFException(String.format("Expected to read %d more bytes from stream", this.bytesToReceive - this.bytesReceived));
    }

    @Override
    public int read() throws IOException {
        if (this.bytesReceived == this.bytesToReceive) {
            return -1;
        }
        int read = this.wrappedInputStream.read();
        if (read < 0) {
            this.throwEOFException();
        }
        ++this.bytesReceived;
        if (this.md != null) {
            this.md.update((byte)read);
            if (this.bytesReceived == this.bytesToReceive) {
                byte[] computedKey = this.md.digest();
                if (!Arrays.equals(computedKey, this.blobKey.getHash())) {
                    this.wrappedOutputStream.write(1);
                    throw new IOException("Detected data corruption during transfer");
                }
                this.wrappedOutputStream.write(0);
            }
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesMissing = this.bytesToReceive - this.bytesReceived;
        if (bytesMissing == 0) {
            return -1;
        }
        int maxRecv = Math.min(len, bytesMissing);
        int read = this.wrappedInputStream.read(b, off, maxRecv);
        if (read < 0) {
            this.throwEOFException();
        }
        this.bytesReceived += read;
        if (this.md != null) {
            this.md.update(b, off, read);
            if (this.bytesReceived == this.bytesToReceive) {
                byte[] computedKey = this.md.digest();
                if (!Arrays.equals(computedKey, this.blobKey.getHash())) {
                    this.wrappedOutputStream.write(1);
                    throw new IOException("Detected data corruption during transfer");
                }
                this.wrappedOutputStream.write(0);
            }
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        return 0L;
    }

    @Override
    public int available() throws IOException {
        return this.bytesToReceive - this.bytesReceived;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

