/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

class ProgressReporter
extends StatusReporter
implements Reporter {
    private TaskInputOutputContext context = null;
    private TaskAttemptContext taskAttemptContext = null;

    public ProgressReporter(TaskAttemptContext context) {
        if (context instanceof TaskInputOutputContext) {
            this.context = (TaskInputOutputContext)context;
        } else {
            this.taskAttemptContext = context;
        }
    }

    public void setStatus(String status) {
        if (this.context != null) {
            this.context.setStatus(status);
        }
    }

    public Counters.Counter getCounter(Enum<?> name) {
        return this.context != null ? (Counters.Counter)this.context.getCounter(name) : null;
    }

    public Counters.Counter getCounter(String group, String name) {
        return this.context != null ? (Counters.Counter)this.context.getCounter(group, name) : null;
    }

    public void incrCounter(Enum<?> key, long amount) {
        if (this.context != null) {
            this.context.getCounter(key).increment(amount);
        }
    }

    public void incrCounter(String group, String counter, long amount) {
        if (this.context != null) {
            this.context.getCounter(group, counter).increment(amount);
        }
    }

    public InputSplit getInputSplit() throws UnsupportedOperationException {
        return null;
    }

    public float getProgress() {
        return 0.0f;
    }

    public void progress() {
        if (this.context != null) {
            this.context.progress();
        } else {
            this.taskAttemptContext.progress();
        }
    }
}

