/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.math.numbertheory;

import java.util.Arrays;
import org.psjava.algo.math.numbertheory.PrimeNumberSieve;
import org.psjava.ds.array.Array;
import org.psjava.ds.array.DynamicArray;
import org.psjava.util.ZeroTo;

public class SieveOfEratosthenes {
    public static PrimeNumberSieve getInstance() {
        return new PrimeNumberSieve(){

            @Override
            public Array<Integer> calcList(int max) {
                boolean[] prime = new boolean[max + 1];
                Arrays.fill(prime, true);
                prime[0] = false;
                prime[1] = false;
                for (int i = 2; i <= max; ++i) {
                    if (!prime[i]) continue;
                    for (int j = i + i; j <= max; j += i) {
                        prime[j] = false;
                    }
                }
                return SieveOfEratosthenes.toArray(max, prime);
            }
        };
    }

    private static DynamicArray<Integer> toArray(int max, boolean[] prime) {
        DynamicArray<Integer> r = DynamicArray.create();
        for (int i : ZeroTo.get(max)) {
            if (!prime[i]) continue;
            r.addToLast(i);
        }
        return r;
    }

    private SieveOfEratosthenes() {
    }
}

