/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.graph.mst;

import java.util.Comparator;
import org.psjava.algo.graph.NumberOfConnectedComponents;
import org.psjava.algo.graph.mst.MinimumSpanningTreeAlgorithm;
import org.psjava.ds.Collection;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.OppositeInUndirectedEdge;
import org.psjava.ds.graph.UndirectedWeightedEdge;
import org.psjava.ds.heap.Heap;
import org.psjava.ds.heap.HeapFactory;
import org.psjava.ds.heap.HeapNode;
import org.psjava.ds.map.MutableMap;
import org.psjava.ds.map.MutableMapFactory;
import org.psjava.ds.numbersystrem.AddableNumberSystem;
import org.psjava.ds.numbersystrem.InfinitableAddableNumberSystem;
import org.psjava.ds.numbersystrem.InfinitableNumber;
import org.psjava.util.AssertStatus;

public class PrimAlgorithm {
    public static MinimumSpanningTreeAlgorithm getInstance(final HeapFactory heapFactory, final MutableMapFactory mapFactory) {
        return new MinimumSpanningTreeAlgorithm(){

            public <W, V, E extends UndirectedWeightedEdge<V, W>> Collection<E> calc(Graph<V, E> graph, AddableNumberSystem<W> weightSystem) {
                AssertStatus.assertTrue(NumberOfConnectedComponents.calc(graph) <= 1);
                final InfinitableAddableNumberSystem<W> ns = InfinitableAddableNumberSystem.wrap(weightSystem);
                DynamicArray result = DynamicArray.create();
                if (graph.getVertices().size() == 0) {
                    return result;
                }
                Object start = graph.getVertices().iterator().next();
                final MutableMap distance = mapFactory.create();
                MutableMap previous = mapFactory.create();
                for (Object v : graph.getVertices()) {
                    distance.add(v, ns.getInfinity());
                }
                distance.replace(start, ns.getZero());
                Heap heap = heapFactory.create(new Comparator<V>(){

                    @Override
                    public int compare(V o1, V o2) {
                        return ns.compare((InfinitableNumber)distance.get(o1), (InfinitableNumber)distance.get(o2));
                    }
                });
                MutableMap nodes = mapFactory.create();
                for (Object v : graph.getVertices()) {
                    nodes.add(v, heap.insert(v));
                }
                while (!heap.isEmpty()) {
                    Object current = heap.extractMinimum();
                    if (previous.containsKey(current)) {
                        result.addToLast(previous.get(current));
                    }
                    for (UndirectedWeightedEdge edge : graph.getEdges(current)) {
                        Object opposite = OppositeInUndirectedEdge.get(edge, current);
                        HeapNode node = (HeapNode)nodes.get(opposite);
                        if (!node.isInHeap()) continue;
                        InfinitableNumber weight = InfinitableNumber.getFiniteInstance(edge.weight());
                        InfinitableNumber oldDistance = (InfinitableNumber)distance.get(opposite);
                        if (ns.compare(oldDistance, weight) <= 0) continue;
                        distance.replace(opposite, weight);
                        previous.addOrReplace(opposite, edge);
                        node.decreaseKey(opposite);
                    }
                }
                return result;
            }
        };
    }

    private PrimAlgorithm() {
    }
}

