/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.algo.geometry.convexhull;

import java.util.Comparator;
import org.psjava.algo.geometry.convexhull.ConvexHullAlgorithm;
import org.psjava.algo.sequence.sort.SortingAlgorithm;
import org.psjava.algo.sequence.sort.SortingHelper;
import org.psjava.ds.array.ArraySwapper;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.array.FirstInArray;
import org.psjava.ds.array.MutableArray;
import org.psjava.ds.array.MutableArrayFromIterable;
import org.psjava.ds.geometry.Point2D;
import org.psjava.ds.geometry.PointByYXComparator;
import org.psjava.ds.geometry.Polygon2D;
import org.psjava.ds.numbersystrem.MultipliableNumberSystem;
import org.psjava.ds.set.Set;
import org.psjava.formula.MinIndexInArray;
import org.psjava.formula.geometry.LeftTurn;
import org.psjava.formula.geometry.PointByDirectionComparator;
import org.psjava.formula.geometry.PointByDistanceComparator;
import org.psjava.util.AssertStatus;
import org.psjava.util.SeriesComparator;

public class GrahamScan {
    public static ConvexHullAlgorithm getInstance(final SortingAlgorithm sortingAlgorithm) {
        return new ConvexHullAlgorithm(){

            @Override
            public <T> Polygon2D<T> calc(Set<Point2D<T>> src, MultipliableNumberSystem<T> ns) {
                AssertStatus.assertTrue(!src.isEmpty(), "points must not be empty");
                MutableArray<Point2D<T>> points = MutableArrayFromIterable.create(src);
                int pivotIndex = GrahamScan.findPivot(points, ns);
                GrahamScan.moveToFront(points, pivotIndex);
                GrahamScan.sortByDirectionBasedOnFirstPoint(sortingAlgorithm, points, ns);
                return GrahamScan.extractConvexHull(points, ns);
            }
        };
    }

    private static <T> int findPivot(MutableArray<Point2D<T>> p, Comparator<T> comp) {
        return MinIndexInArray.get(p, PointByYXComparator.create(comp));
    }

    private static <T> void moveToFront(MutableArray<Point2D<T>> points, int indexToMove) {
        ArraySwapper.swap(points, 0, indexToMove);
    }

    private static <T> void sortByDirectionBasedOnFirstPoint(SortingAlgorithm sa, MutableArray<Point2D<T>> points, MultipliableNumberSystem<T> ns) {
        Point2D<T> first = FirstInArray.getFirst(points);
        Point2D<T> basis = Point2D.create(ns.add(first.x(), ns.getOne()), first.y());
        Comparator comparatorByFirstPoint = SeriesComparator.create(PointByDirectionComparator.create(ns, first, basis), PointByDistanceComparator.create(first, ns));
        SortingHelper.sort(sa, points, 1, points.size(), comparatorByFirstPoint);
    }

    private static <T> Polygon2D<T> extractConvexHull(MutableArray<Point2D<T>> sortedPoints, MultipliableNumberSystem<T> ns) {
        DynamicArray<Point2D<Point2D>> hull = new DynamicArray<Point2D<Point2D>>();
        for (Point2D point2D : sortedPoints) {
            while (GrahamScan.canRemoveLastPoint(hull, point2D, ns)) {
                hull.removeLast();
            }
            hull.addToLast(point2D);
        }
        return Polygon2D.create(hull);
    }

    private static <T> boolean canRemoveLastPoint(MutableArray<Point2D<T>> hull, Point2D<T> newPoint, MultipliableNumberSystem<T> ns) {
        return hull.size() >= 2 && !LeftTurn.is((Point2D)hull.get(hull.size() - 2), (Point2D)hull.get(hull.size() - 1), newPoint, ns);
    }

    private GrahamScan() {
    }
}

