/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.script.ScriptLanguageAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkHrefAttribute;
import org.odftoolkit.odfdom.dom.attribute.xlink.XlinkTypeAttribute;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class TextScriptElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "script");

    public TextScriptElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public String getScriptLanguageAttribute() {
        ScriptLanguageAttribute attr = (ScriptLanguageAttribute)this.getOdfAttribute(OdfDocumentNamespace.SCRIPT, "language");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setScriptLanguageAttribute(String scriptLanguageValue) {
        ScriptLanguageAttribute attr = new ScriptLanguageAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(scriptLanguageValue);
    }

    public String getXlinkHrefAttribute() {
        XlinkHrefAttribute attr = (XlinkHrefAttribute)this.getOdfAttribute(OdfDocumentNamespace.XLINK, "href");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setXlinkHrefAttribute(String xlinkHrefValue) {
        XlinkHrefAttribute attr = new XlinkHrefAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xlinkHrefValue);
    }

    public String getXlinkTypeAttribute() {
        XlinkTypeAttribute attr = (XlinkTypeAttribute)this.getOdfAttribute(OdfDocumentNamespace.XLINK, "type");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return "simple";
    }

    public void setXlinkTypeAttribute(String xlinkTypeValue) {
        XlinkTypeAttribute attr = new XlinkTypeAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(xlinkTypeValue);
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }

    public void newTextNode(String content) {
        if (content != null && !content.equals("")) {
            this.appendChild(this.getOwnerDocument().createTextNode(content));
        }
    }
}

