/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.ImmutableArrayList;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.ModuleInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.Utils;

public final class Index
implements IndexView {
    private static final List<AnnotationInstance> EMPTY_ANNOTATION_LIST = Collections.emptyList();
    private static final List<ClassInfo> EMPTY_CLASSINFO_LIST = Collections.emptyList();
    final Map<DotName, AnnotationInstance[]> annotations;
    final Map<DotName, ClassInfo[]> subclasses;
    final Map<DotName, ClassInfo[]> subinterfaces;
    final Map<DotName, ClassInfo[]> implementors;
    final Map<DotName, ClassInfo> classes;
    final Map<DotName, ModuleInfo> modules;
    final Map<DotName, ClassInfo[]> users;
    volatile Map<DotName, Collection<ClassInfo>> classesInPackage;
    volatile Map<DotName, Set<DotName>> subpackages;

    Index(Map<DotName, AnnotationInstance[]> annotations, Map<DotName, ClassInfo[]> subclasses, Map<DotName, ClassInfo[]> subinterfaces, Map<DotName, ClassInfo[]> implementors, Map<DotName, ClassInfo> classes, Map<DotName, ModuleInfo> modules, Map<DotName, ClassInfo[]> users) {
        this.annotations = annotations;
        this.classes = classes;
        this.subclasses = subclasses;
        this.subinterfaces = subinterfaces;
        this.implementors = implementors;
        this.modules = modules;
        this.users = users;
    }

    public static Index create(Map<DotName, List<AnnotationInstance>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, List<ClassInfo>> implementors, Map<DotName, ClassInfo> classes) {
        return new Index(Utils.unfold(annotations, AnnotationInstance.class), Utils.unfold(subclasses, ClassInfo.class), Collections.emptyMap(), Utils.unfold(implementors, ClassInfo.class), classes, Collections.emptyMap(), Collections.emptyMap());
    }

    public static Index create(Map<DotName, List<AnnotationInstance>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, List<ClassInfo>> implementors, Map<DotName, ClassInfo> classes, Map<DotName, List<ClassInfo>> users) {
        return new Index(Utils.unfold(annotations, AnnotationInstance.class), Utils.unfold(subclasses, ClassInfo.class), Collections.emptyMap(), Utils.unfold(implementors, ClassInfo.class), classes, Collections.emptyMap(), Utils.unfold(users, ClassInfo.class));
    }

    public static Index create(Map<DotName, List<AnnotationInstance>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, List<ClassInfo>> subinterfaces, Map<DotName, List<ClassInfo>> implementors, Map<DotName, ClassInfo> classes, Map<DotName, List<ClassInfo>> users) {
        return new Index(Utils.unfold(annotations, AnnotationInstance.class), Utils.unfold(subclasses, ClassInfo.class), Utils.unfold(subinterfaces, ClassInfo.class), Utils.unfold(implementors, ClassInfo.class), classes, Collections.emptyMap(), Utils.unfold(users, ClassInfo.class));
    }

    public static Index create(Map<DotName, List<AnnotationInstance>> annotations, Map<DotName, List<ClassInfo>> subclasses, Map<DotName, List<ClassInfo>> subinterfaces, Map<DotName, List<ClassInfo>> implementors, Map<DotName, ClassInfo> classes, Map<DotName, ModuleInfo> modules, Map<DotName, List<ClassInfo>> users) {
        return new Index(Utils.unfold(annotations, AnnotationInstance.class), Utils.unfold(subclasses, ClassInfo.class), Utils.unfold(subinterfaces, ClassInfo.class), Utils.unfold(implementors, ClassInfo.class), classes, modules, Utils.unfold(users, ClassInfo.class));
    }

    public static Index of(Iterable<Class<?>> classes) throws IOException {
        Indexer indexer = new Indexer();
        for (Class<?> clazz : classes) {
            indexer.indexClass(clazz);
        }
        return indexer.complete();
    }

    public static Index of(Class<?> ... classes) throws IOException {
        return Index.of(Arrays.asList(classes));
    }

    public static Index of(File ... files) throws IOException {
        Indexer indexer = new Indexer();
        for (File file : files) {
            if (file == null) {
                throw new IllegalArgumentException("File must not be null");
            }
            if (file.isDirectory()) {
                File[] classFiles;
                for (File classFile : classFiles = file.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().endsWith(".class");
                    }
                })) {
                    try (FileInputStream in = new FileInputStream(classFile);){
                        indexer.index(in);
                    }
                }
                continue;
            }
            if (file.isFile() && file.getName().endsWith(".class")) {
                try (FileInputStream in = new FileInputStream(file);){
                    indexer.index(in);
                    continue;
                }
            }
            if (file.isFile() && file.getName().endsWith(".jar")) {
                try (JarFile jarFile = new JarFile(file);){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        InputStream in = jarFile.getInputStream(entry);
                        try {
                            indexer.index(in);
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                    continue;
                }
            }
            throw new IllegalArgumentException("Not a class file, JAR file or directory: " + file);
        }
        return indexer.complete();
    }

    public static ClassInfo singleClass(Class<?> clazz) throws IOException {
        Indexer indexer = new Indexer();
        indexer.indexClass(clazz);
        Index index = indexer.complete();
        return index.getKnownClasses().iterator().next();
    }

    public static ClassInfo singleClass(byte[] classData) throws IOException {
        return Index.singleClass(new ByteArrayInputStream(classData));
    }

    public static ClassInfo singleClass(InputStream classData) throws IOException {
        Indexer indexer = new Indexer();
        indexer.index(classData);
        Index index = indexer.complete();
        return index.getKnownClasses().iterator().next();
    }

    public List<AnnotationInstance> getAnnotations(DotName annotationName) {
        AnnotationInstance[] list = this.annotations.get(annotationName);
        return list == null ? EMPTY_ANNOTATION_LIST : new ImmutableArrayList<AnnotationInstance>(list);
    }

    @Override
    public Collection<AnnotationInstance> getAnnotationsWithRepeatable(DotName annotationName, IndexView index) {
        ClassInfo annotationClass = index.getClassByName(annotationName);
        if (annotationClass == null) {
            throw new IllegalArgumentException("Index does not contain the annotation definition: " + annotationName);
        }
        if (!annotationClass.isAnnotation()) {
            throw new IllegalArgumentException("Not an annotation type: " + annotationClass);
        }
        AnnotationInstance repeatable = annotationClass.declaredAnnotation(DotName.REPEATABLE_NAME);
        if (repeatable == null) {
            return this.getAnnotations(annotationName);
        }
        Type containing = repeatable.value().asClass();
        return this.getRepeatableAnnotations(annotationName, containing.name());
    }

    private Collection<AnnotationInstance> getRepeatableAnnotations(DotName annotationName, DotName containingAnnotationName) {
        ArrayList<AnnotationInstance> instances = new ArrayList<AnnotationInstance>();
        instances.addAll(this.getAnnotations(annotationName));
        for (AnnotationInstance containingInstance : this.getAnnotations(containingAnnotationName)) {
            for (AnnotationInstance nestedInstance : containingInstance.value().asNestedArray()) {
                instances.add(AnnotationInstance.create(nestedInstance, containingInstance.target()));
            }
        }
        return instances;
    }

    public List<ClassInfo> getKnownDirectSubclasses(DotName className) {
        ClassInfo[] list = this.subclasses.get(className);
        return list == null ? EMPTY_CLASSINFO_LIST : new ImmutableArrayList<ClassInfo>(list);
    }

    @Override
    public Collection<ClassInfo> getAllKnownSubclasses(DotName className) {
        HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        this.getAllKnownSubClasses(className, allKnown, processedClasses);
        return allKnown;
    }

    private void getAllKnownSubClasses(DotName className, Set<ClassInfo> allKnown, Set<DotName> processedClasses) {
        HashSet<DotName> subClassesToProcess = new HashSet<DotName>();
        subClassesToProcess.add(className);
        while (!subClassesToProcess.isEmpty()) {
            Iterator toProcess = subClassesToProcess.iterator();
            DotName name = (DotName)toProcess.next();
            toProcess.remove();
            processedClasses.add(name);
            this.getAllKnownSubClasses(name, allKnown, subClassesToProcess, processedClasses);
        }
    }

    private void getAllKnownSubClasses(DotName name, Set<ClassInfo> allKnown, Set<DotName> subClassesToProcess, Set<DotName> processedClasses) {
        Collection list = this.getKnownDirectSubclasses(name);
        if (list != null) {
            for (ClassInfo clazz : list) {
                DotName className = clazz.name();
                if (processedClasses.contains(className)) continue;
                allKnown.add(clazz);
                subClassesToProcess.add(className);
            }
        }
    }

    public List<ClassInfo> getKnownDirectSubinterfaces(DotName interfaceName) {
        ClassInfo[] list = this.subinterfaces.get(interfaceName);
        return list == null ? EMPTY_CLASSINFO_LIST : new ImmutableArrayList<ClassInfo>(list);
    }

    @Override
    public Collection<ClassInfo> getAllKnownSubinterfaces(DotName interfaceName) {
        HashSet<ClassInfo> result = new HashSet<ClassInfo>();
        ArrayDeque<DotName> workQueue = new ArrayDeque<DotName>();
        HashSet<DotName> alreadyProcessed = new HashSet<DotName>();
        workQueue.add(interfaceName);
        while (!workQueue.isEmpty()) {
            DotName iface = (DotName)workQueue.remove();
            if (!alreadyProcessed.add(iface)) continue;
            for (ClassInfo directSubinterface : this.getKnownDirectSubinterfaces(iface)) {
                result.add(directSubinterface);
                workQueue.add(directSubinterface.name());
            }
        }
        return result;
    }

    public List<ClassInfo> getKnownDirectImplementors(DotName interfaceName) {
        ClassInfo[] list = this.implementors.get(interfaceName);
        return list == null ? EMPTY_CLASSINFO_LIST : new ImmutableArrayList<ClassInfo>(list);
    }

    public Set<ClassInfo> getAllKnownImplementors(DotName interfaceName) {
        HashSet<ClassInfo> allKnown = new HashSet<ClassInfo>();
        HashSet<DotName> subInterfacesToProcess = new HashSet<DotName>();
        HashSet<DotName> processedClasses = new HashSet<DotName>();
        subInterfacesToProcess.add(interfaceName);
        while (!subInterfacesToProcess.isEmpty()) {
            Iterator toProcess = subInterfacesToProcess.iterator();
            DotName name = (DotName)toProcess.next();
            toProcess.remove();
            processedClasses.add(name);
            this.getKnownImplementors(name, allKnown, subInterfacesToProcess, processedClasses);
        }
        return allKnown;
    }

    private void getKnownImplementors(DotName name, Set<ClassInfo> allKnown, Set<DotName> subInterfacesToProcess, Set<DotName> processedClasses) {
        Collection list = this.getKnownDirectImplementors(name);
        if (list != null) {
            for (ClassInfo clazz : list) {
                DotName className = clazz.name();
                if (processedClasses.contains(className)) continue;
                if (Modifier.isInterface(clazz.flags())) {
                    subInterfacesToProcess.add(className);
                    continue;
                }
                if (allKnown.contains(clazz)) continue;
                allKnown.add(clazz);
                processedClasses.add(className);
                this.getAllKnownSubClasses(className, allKnown, processedClasses);
            }
        }
    }

    @Override
    public ClassInfo getClassByName(DotName className) {
        return this.classes.get(className);
    }

    @Override
    public Collection<ClassInfo> getKnownClasses() {
        return this.classes.values();
    }

    @Override
    public Collection<ModuleInfo> getKnownModules() {
        return this.modules.values();
    }

    @Override
    public ModuleInfo getModuleByName(DotName moduleName) {
        return this.modules.get(moduleName);
    }

    public List<ClassInfo> getKnownUsers(DotName className) {
        ClassInfo[] ret = this.users.get(className);
        return ret == null ? EMPTY_CLASSINFO_LIST : new ImmutableArrayList<ClassInfo>(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ClassInfo> getClassesInPackage(DotName packageName) {
        Collection<ClassInfo> result;
        if (this.classesInPackage == null) {
            Index index = this;
            synchronized (index) {
                if (this.classesInPackage == null) {
                    HashMap<DotName, Collection> map = new HashMap<DotName, Collection>();
                    for (ClassInfo clazz : this.classes.values()) {
                        DotName pkg = clazz.name().packagePrefixName();
                        map.computeIfAbsent(pkg, ignored -> new ArrayList()).add(clazz);
                    }
                    this.classesInPackage = Collections.unmodifiableMap(map);
                }
            }
        }
        return (result = this.classesInPackage.get(packageName)) != null ? Collections.unmodifiableCollection(result) : EMPTY_CLASSINFO_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<DotName> getSubpackages(DotName packageName) {
        Set<DotName> result;
        if (this.subpackages == null) {
            Index index = this;
            synchronized (index) {
                if (this.subpackages == null) {
                    HashMap<DotName, Set> map = new HashMap<DotName, Set>();
                    for (ClassInfo clazz : this.classes.values()) {
                        DotName pkg = clazz.name().packagePrefixName();
                        while (pkg != null) {
                            DotName superPkg = pkg.packagePrefixName();
                            if (superPkg != null) {
                                map.computeIfAbsent(superPkg, ignored -> new HashSet()).add(pkg);
                            }
                            pkg = superPkg;
                        }
                    }
                    this.subpackages = Collections.unmodifiableMap(map);
                }
            }
        }
        return (result = this.subpackages.get(packageName)) != null ? Collections.unmodifiableSet(result) : Collections.emptySet();
    }

    public void printAnnotations() {
        System.out.println("Annotations:");
        for (Map.Entry<DotName, AnnotationInstance[]> e : this.annotations.entrySet()) {
            System.out.println(e.getKey() + ":");
            for (AnnotationInstance instance : e.getValue()) {
                AnnotationTarget target = instance.target();
                if (target instanceof ClassInfo) {
                    System.out.println("    Class: " + target);
                } else if (target instanceof FieldInfo) {
                    System.out.println("    Field: " + target);
                } else if (target instanceof MethodInfo) {
                    System.out.println("    Method: " + target);
                } else if (target instanceof MethodParameterInfo) {
                    System.out.println("    Parameter: " + target);
                }
                List<AnnotationValue> values = instance.values();
                if (values.size() < 1) continue;
                StringBuilder builder = new StringBuilder("        (");
                for (int i = 0; i < values.size(); ++i) {
                    builder.append(values.get(i));
                    if (i >= values.size() - 1) continue;
                    builder.append(", ");
                }
                builder.append(')');
                System.out.println(builder.toString());
            }
        }
    }

    public void printSubclasses() {
        System.out.println("Subclasses:");
        for (Map.Entry<DotName, ClassInfo[]> entry : this.subclasses.entrySet()) {
            System.out.println(entry.getKey() + ":");
            for (ClassInfo clazz : entry.getValue()) {
                System.out.println("    " + clazz.name());
            }
        }
    }
}

