/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.util.Messages;

public class DelegatingFileSystemOptionsBuilder {
    private static final Class<String>[] STRING_PARAM = new Class[]{String.class};
    private static final Map<String, Class<?>> PRIMITIVE_TO_OBJECT = new TreeMap();
    private static final Log log = LogFactory.getLog(DelegatingFileSystemOptionsBuilder.class);
    private final FileSystemManager manager;
    private final Map<String, Map<String, List<Method>>> beanMethods = new TreeMap<String, Map<String, List<Method>>>();

    public DelegatingFileSystemOptionsBuilder(FileSystemManager manager) {
        this.manager = manager;
    }

    private boolean convertValuesAndInvoke(Method configSetter, Context ctx) throws FileSystemException {
        Method valueFactory;
        Constructor<?> valueConstructor;
        Class<?> valueClass;
        Class<?> type;
        Class<?>[] parameters = configSetter.getParameterTypes();
        if (parameters.length < 2) {
            return false;
        }
        if (!parameters[0].isAssignableFrom(FileSystemOptions.class)) {
            return false;
        }
        Class<?> valueParameter = parameters[1];
        if (valueParameter.isArray()) {
            type = valueParameter.getComponentType();
        } else {
            if (ctx.values.length > 1) {
                return false;
            }
            type = valueParameter;
        }
        if (type.isPrimitive()) {
            Class<?> objectType = PRIMITIVE_TO_OBJECT.get(type.getName());
            if (objectType == null) {
                log.warn((Object)Messages.getString("vfs.provider/config-unexpected-primitive.error", (Object)type.getName()));
                return false;
            }
            type = objectType;
        }
        if (type.isAssignableFrom(valueClass = ctx.values[0].getClass())) {
            this.invokeSetter(valueParameter, ctx, configSetter, ctx.values);
            return true;
        }
        if (valueClass != String.class) {
            log.warn((Object)Messages.getString("vfs.provider/config-unexpected-value-class.error", valueClass.getName(), ctx.scheme, ctx.name));
            return false;
        }
        Object convertedValues = Array.newInstance(type, ctx.values.length);
        try {
            valueConstructor = type.getConstructor(STRING_PARAM);
        }
        catch (NoSuchMethodException e) {
            valueConstructor = null;
        }
        if (valueConstructor != null) {
            for (int iterValues = 0; iterValues < ctx.values.length; ++iterValues) {
                try {
                    Array.set(convertedValues, iterValues, valueConstructor.newInstance(ctx.values[iterValues]));
                    continue;
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new FileSystemException(e);
                }
            }
            this.invokeSetter(valueParameter, ctx, configSetter, convertedValues);
            return true;
        }
        try {
            valueFactory = type.getMethod("valueOf", STRING_PARAM);
            if (!Modifier.isStatic(valueFactory.getModifiers())) {
                valueFactory = null;
            }
        }
        catch (NoSuchMethodException e) {
            valueFactory = null;
        }
        if (valueFactory != null) {
            for (int iterValues = 0; iterValues < ctx.values.length; ++iterValues) {
                try {
                    Array.set(convertedValues, iterValues, valueFactory.invoke(null, ctx.values[iterValues]));
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new FileSystemException(e);
                }
            }
            this.invokeSetter(valueParameter, ctx, configSetter, convertedValues);
            return true;
        }
        return false;
    }

    private Map<String, List<Method>> createSchemeMethods(String scheme) throws FileSystemException {
        Method[] methods;
        FileSystemConfigBuilder fscb = this.getManager().getFileSystemConfigBuilder(scheme);
        FileSystemException.requireNonNull(fscb, "vfs.provider/no-config-builder.error", scheme);
        TreeMap<String, List<Method>> schemeMethods = new TreeMap<String, List<Method>>();
        for (Method method : methods = fscb.getClass().getMethods()) {
            String methodName;
            if (!Modifier.isPublic(method.getModifiers()) || !(methodName = method.getName()).startsWith("set")) continue;
            String key = methodName.substring(3).toLowerCase();
            List configSetter = schemeMethods.computeIfAbsent(key, k -> new ArrayList(2));
            configSetter.add(method);
        }
        return schemeMethods;
    }

    private boolean fillConfigSetters(Context ctx) throws FileSystemException {
        Map<String, List<Method>> schemeMethods = this.getSchemeMethods(ctx.scheme);
        List<Method> configSetters = schemeMethods.get(ctx.name.toLowerCase());
        if (configSetters == null) {
            return false;
        }
        ctx.configSetters = configSetters;
        return true;
    }

    protected FileSystemManager getManager() {
        return this.manager;
    }

    private Map<String, List<Method>> getSchemeMethods(String scheme) throws FileSystemException {
        Map<String, List<Method>> schemeMethods = this.beanMethods.get(scheme);
        if (schemeMethods == null) {
            schemeMethods = this.createSchemeMethods(scheme);
            this.beanMethods.put(scheme, schemeMethods);
        }
        return schemeMethods;
    }

    private void invokeSetter(Class<?> valueParameter, Context ctx, Method configSetter, Object values) throws FileSystemException {
        Object[] args = valueParameter.isArray() ? new Object[]{ctx.fso, values} : new Object[]{ctx.fso, Array.get(values, 0)};
        try {
            configSetter.invoke((Object)ctx.fileSystemConfigBuilder, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new FileSystemException(e);
        }
    }

    public void setConfigClass(FileSystemOptions fso, String scheme, String name, Class<?> className) throws FileSystemException, ReflectiveOperationException {
        this.setConfigClasses(fso, scheme, name, new Class[]{className});
    }

    public void setConfigClasses(FileSystemOptions fso, String scheme, String name, Class<?>[] classNames) throws FileSystemException, ReflectiveOperationException {
        Object[] values = new Object[classNames.length];
        for (int iterClassNames = 0; iterClassNames < values.length; ++iterClassNames) {
            values[iterClassNames] = classNames[iterClassNames].getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        Context ctx = new Context(fso, scheme, name, values);
        this.setValues(ctx);
    }

    public void setConfigString(FileSystemOptions fso, String scheme, String name, String value) throws FileSystemException {
        this.setConfigStrings(fso, scheme, name, new String[]{value});
    }

    public void setConfigStrings(FileSystemOptions fso, String scheme, String name, String[] values) throws FileSystemException {
        Context ctx = new Context(fso, scheme, name, values);
        this.setValues(ctx);
    }

    private void setValues(Context ctx) throws FileSystemException {
        if (!this.fillConfigSetters(ctx)) {
            throw new FileSystemException("vfs.provider/config-key-invalid.error", ctx.scheme, ctx.name);
        }
        ctx.fileSystemConfigBuilder = this.getManager().getFileSystemConfigBuilder(ctx.scheme);
        for (Method configSetter : ctx.configSetters) {
            if (!this.convertValuesAndInvoke(configSetter, ctx)) continue;
            return;
        }
        throw new FileSystemException("vfs.provider/config-value-invalid.error", ctx.scheme, ctx.name, ctx.values);
    }

    static {
        PRIMITIVE_TO_OBJECT.put(Void.TYPE.getName(), Void.class);
        PRIMITIVE_TO_OBJECT.put(Boolean.TYPE.getName(), Boolean.class);
        PRIMITIVE_TO_OBJECT.put(Byte.TYPE.getName(), Byte.class);
        PRIMITIVE_TO_OBJECT.put(Character.TYPE.getName(), Character.class);
        PRIMITIVE_TO_OBJECT.put(Short.TYPE.getName(), Short.class);
        PRIMITIVE_TO_OBJECT.put(Integer.TYPE.getName(), Integer.class);
        PRIMITIVE_TO_OBJECT.put(Long.TYPE.getName(), Long.class);
        PRIMITIVE_TO_OBJECT.put(Double.TYPE.getName(), Double.class);
        PRIMITIVE_TO_OBJECT.put(Float.TYPE.getName(), Float.class);
    }

    private static final class Context {
        private final FileSystemOptions fso;
        private final String scheme;
        private final String name;
        private final Object[] values;
        private List<Method> configSetters;
        private FileSystemConfigBuilder fileSystemConfigBuilder;

        private Context(FileSystemOptions fso, String scheme, String name, Object[] values) {
            this.fso = fso;
            this.scheme = scheme;
            this.name = name;
            this.values = values;
        }
    }
}

