/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.DelegateFileObject;

public class VirtualFileSystem
extends AbstractFileSystem {
    private final Map<FileName, FileObject> junctions = new HashMap<FileName, FileObject>();

    public VirtualFileSystem(AbstractFileName rootFileName, FileSystemOptions fileSystemOptions) {
        super(rootFileName, null, fileSystemOptions);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.add(Capability.ATTRIBUTES);
        caps.add(Capability.CREATE);
        caps.add(Capability.DELETE);
        caps.add(Capability.GET_TYPE);
        caps.add(Capability.JUNCTIONS);
        caps.add(Capability.GET_LAST_MODIFIED);
        caps.add(Capability.SET_LAST_MODIFIED_FILE);
        caps.add(Capability.SET_LAST_MODIFIED_FOLDER);
        caps.add(Capability.LIST_CHILDREN);
        caps.add(Capability.READ_CONTENT);
        caps.add(Capability.SIGNING);
        caps.add(Capability.WRITE_CONTENT);
        caps.add(Capability.APPEND_CONTENT);
    }

    @Override
    public void addJunction(String junctionPoint, FileObject targetFile) throws FileSystemException {
        FileName junctionName = this.getFileSystemManager().resolveName(this.getRootName(), junctionPoint);
        if (this.getJunctionForFile(junctionName) != null) {
            throw new FileSystemException("vfs.impl/nested-junction.error", (Object)junctionName);
        }
        try {
            this.junctions.put(junctionName, targetFile);
            DelegateFileObject junctionFile = (DelegateFileObject)this.getFileFromCache(junctionName);
            if (junctionFile != null) {
                junctionFile.setFile(targetFile);
            }
            FileName childName = junctionName;
            boolean done = false;
            for (AbstractFileName parentName = (AbstractFileName)childName.getParent(); !done && parentName != null; parentName = (AbstractFileName)parentName.getParent()) {
                DelegateFileObject<VirtualFileSystem> file = (DelegateFileObject<VirtualFileSystem>)this.getFileFromCache(parentName);
                if (file == null) {
                    file = new DelegateFileObject<VirtualFileSystem>(parentName, this, null);
                    this.putFileToCache(file);
                } else {
                    done = file.exists();
                }
                file.attachChild(childName, FileType.FOLDER);
                childName = parentName;
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.impl/create-junction.error", (Object)junctionName, (Throwable)e);
        }
    }

    @Override
    public void close() {
        super.close();
        this.junctions.clear();
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        FileObject file;
        FileName junctionPoint = this.getJunctionForFile(name);
        if (junctionPoint != null) {
            FileObject junctionFile = this.junctions.get(junctionPoint);
            String relName = junctionPoint.getRelativeName(name);
            file = junctionFile.resolveFile(relName, NameScope.DESCENDENT_OR_SELF);
        } else {
            file = null;
        }
        return new DelegateFileObject<VirtualFileSystem>(name, this, file);
    }

    private FileName getJunctionForFile(FileName name) {
        if (this.junctions.containsKey(name)) {
            return name;
        }
        return this.junctions.keySet().stream().filter(fileName -> fileName.isDescendent(name)).findFirst().orElse(null);
    }

    @Override
    public void removeJunction(String junctionPoint) throws FileSystemException {
        FileName junctionName = this.getFileSystemManager().resolveName(this.getRootName(), junctionPoint);
        this.junctions.remove(junctionName);
    }
}

