/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class UserAuthenticationData {
    public static final Type USERNAME = new Type("username");
    public static final Type PASSWORD = new Type("password");
    public static final Type DOMAIN = new Type("domain");
    private final Map<Type, char[]> authenticationData = new TreeMap<Type, char[]>();

    public void cleanup() {
        for (char[] data : this.authenticationData.values()) {
            if (data == null) continue;
            Arrays.fill(data, '\u0000');
        }
        this.authenticationData.clear();
    }

    public char[] getData(Type type) {
        return this.authenticationData.get(type);
    }

    public void setData(Type type, char[] data) {
        this.authenticationData.put(type, data);
    }

    public static class Type
    implements Comparable<Type> {
        private final String type;

        public Type(String type) {
            this.type = type;
        }

        @Override
        public int compareTo(Type o) {
            return this.type.compareTo(o.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Objects.equals(this.type, ((Type)o).type);
        }

        public int hashCode() {
            return this.type != null ? this.type.hashCode() : 0;
        }

        public String toString() {
            return this.type;
        }
    }
}

