/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.util.Collections;
import java.util.Set;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.jobhistory.EventType;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JobUnsuccessfulCompletion;
import org.apache.hadoop.thirdparty.com.google.common.base.Joiner;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobUnsuccessfulCompletionEvent
implements HistoryEvent {
    private static final String NODIAGS = "";
    private static final Iterable<String> NODIAGS_LIST = Collections.singletonList("");
    private JobUnsuccessfulCompletion datum = new JobUnsuccessfulCompletion();

    public JobUnsuccessfulCompletionEvent(JobID id, long finishTime, int succeededMaps, int succeededReduces, int failedMaps, int failedReduces, int killedMaps, int killedReduces, String status) {
        this(id, finishTime, succeededMaps, succeededReduces, failedMaps, failedReduces, killedMaps, killedReduces, status, NODIAGS_LIST);
    }

    public JobUnsuccessfulCompletionEvent(JobID id, long finishTime, int succeededMaps, int succeededReduces, int failedMaps, int failedReduces, int killedMaps, int killedReduces, String status, Iterable<String> diagnostics) {
        this.datum.setJobid((CharSequence)new Utf8(id.toString()));
        this.datum.setFinishTime(finishTime);
        this.datum.setFinishedMaps(succeededMaps);
        this.datum.setFinishedReduces(succeededReduces);
        this.datum.setFailedMaps(failedMaps);
        this.datum.setFailedReduces(failedReduces);
        this.datum.setKilledMaps(killedMaps);
        this.datum.setKilledReduces(killedReduces);
        this.datum.setJobStatus((CharSequence)new Utf8(status));
        if (diagnostics == null) {
            diagnostics = NODIAGS_LIST;
        }
        this.datum.setDiagnostics((CharSequence)new Utf8(Joiner.on((char)'\n').skipNulls().join(diagnostics)));
    }

    JobUnsuccessfulCompletionEvent() {
    }

    @Override
    public Object getDatum() {
        return this.datum;
    }

    @Override
    public void setDatum(Object datum) {
        this.datum = (JobUnsuccessfulCompletion)((Object)datum);
    }

    public JobID getJobId() {
        return JobID.forName(this.datum.getJobid().toString());
    }

    public long getFinishTime() {
        return this.datum.getFinishTime();
    }

    public int getSucceededMaps() {
        return this.datum.getFinishedMaps();
    }

    public int getSucceededReduces() {
        return this.datum.getFinishedReduces();
    }

    public int getFailedMaps() {
        return this.datum.getFailedMaps();
    }

    public int getFailedReduces() {
        return this.datum.getFailedReduces();
    }

    public int getKilledMaps() {
        return this.datum.getKilledMaps();
    }

    public int getKilledReduces() {
        return this.datum.getKilledReduces();
    }

    public String getStatus() {
        return this.datum.getJobStatus().toString();
    }

    @Override
    public EventType getEventType() {
        if ("FAILED".equals(this.getStatus())) {
            return EventType.JOB_FAILED;
        }
        if ("ERROR".equals(this.getStatus())) {
            return EventType.JOB_ERROR;
        }
        return EventType.JOB_KILLED;
    }

    public String getDiagnostics() {
        CharSequence diagnostics = this.datum.getDiagnostics();
        return diagnostics == null ? NODIAGS : diagnostics.toString();
    }

    @Override
    public TimelineEvent toTimelineEvent() {
        TimelineEvent tEvent = new TimelineEvent();
        tEvent.setId(StringUtils.toUpperCase((String)this.getEventType().name()));
        tEvent.addInfo("FINISH_TIME", (Object)this.getFinishTime());
        tEvent.addInfo("NUM_MAPS", (Object)(this.getSucceededMaps() + this.getFailedMaps() + this.getKilledMaps()));
        tEvent.addInfo("NUM_REDUCES", (Object)(this.getSucceededReduces() + this.getFailedReduces() + this.getKilledReduces()));
        tEvent.addInfo("JOB_STATUS", (Object)this.getStatus());
        tEvent.addInfo("DIAGNOSTICS", (Object)this.getDiagnostics());
        tEvent.addInfo("SUCCESSFUL_MAPS", (Object)this.getSucceededMaps());
        tEvent.addInfo("SUCCESSFUL_REDUCES", (Object)this.getSucceededReduces());
        tEvent.addInfo("FAILED_MAPS", (Object)this.getFailedMaps());
        tEvent.addInfo("FAILED_REDUCES", (Object)this.getFailedReduces());
        tEvent.addInfo("KILLED_MAPS", (Object)this.getKilledMaps());
        tEvent.addInfo("KILLED_REDUCES", (Object)this.getKilledReduces());
        return tEvent;
    }

    @Override
    public Set<TimelineMetric> getTimelineMetrics() {
        return null;
    }
}

