/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.plugin;

import com.amazon.redshift.INativePlugin;
import com.amazon.redshift.NativeTokenHolder;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.plugin.IdpCredentialsProvider;
import com.amazon.redshift.util.RedshiftException;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class JwtCredentialsProvider
extends IdpCredentialsProvider
implements INativePlugin {
    private static final String KEY_PROVIDER_NAME = "providerName";
    protected Boolean m_disableCache = false;
    private String m_providerName;
    private static Map<String, NativeTokenHolder> m_cache = new HashMap<String, NativeTokenHolder>();
    private NativeTokenHolder m_lastRefreshCredentials;
    private static final String LOG_PROPERTIES_FILE_NAME = "log-factory.properties";
    private static final String LOG_PROPERTIES_FILE_PATH = "META-INF/services/org.apache.commons.logging.LogFactory";
    private static final ClassLoader CONTEXT_CLASS_LOADER = new ClassLoader(JwtCredentialsProvider.class.getClassLoader()){

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.getParent().loadClass(name);
            return clazz;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if ("commons-logging.properties".equals(name)) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }

        @Override
        public URL getResource(String name) {
            if (JwtCredentialsProvider.LOG_PROPERTIES_FILE_PATH.equals(name)) {
                return JwtCredentialsProvider.class.getResource(JwtCredentialsProvider.LOG_PROPERTIES_FILE_NAME);
            }
            return super.getResource(name);
        }
    };

    @Override
    public void addParameter(String key, String value) {
        if (RedshiftLogger.isEnable()) {
            this.m_log.logDebug("key: {0}", key);
        }
        if (RedshiftProperty.IAM_DISABLE_CACHE.getName().equalsIgnoreCase(key)) {
            this.m_disableCache = Boolean.valueOf(value);
        } else if (KEY_PROVIDER_NAME.equalsIgnoreCase(key)) {
            this.m_providerName = value;
        } else if ("ssl_insecure".equalsIgnoreCase(key)) {
            this.m_sslInsecure = Boolean.parseBoolean(value);
        }
    }

    protected boolean isNullOrEmpty(String val) {
        return val == null || val.length() == 0;
    }

    @Override
    public void setLogger(RedshiftLogger log) {
        this.m_log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeTokenHolder getCredentials() throws RedshiftException {
        NativeTokenHolder credentials = null;
        if (!this.m_disableCache.booleanValue()) {
            String key = this.getCacheKey();
            credentials = m_cache.get(key);
        }
        if (credentials == null || credentials.isExpired()) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logInfo("JWT getCredentials NOT from cache", new Object[0]);
            }
            JwtCredentialsProvider jwtCredentialsProvider = this;
            synchronized (jwtCredentialsProvider) {
                this.refresh();
                if (this.m_disableCache.booleanValue()) {
                    credentials = this.m_lastRefreshCredentials;
                    this.m_lastRefreshCredentials = null;
                }
            }
        } else {
            credentials.setRefresh(false);
            if (RedshiftLogger.isEnable()) {
                this.m_log.logInfo("JWT getCredentials from cache", new Object[0]);
            }
        }
        if (!this.m_disableCache.booleanValue()) {
            credentials = m_cache.get(this.getCacheKey());
        }
        if (credentials == null) {
            throw new RedshiftException("Unable to get IDP credentials");
        }
        return credentials;
    }

    protected abstract String getJwtAssertion() throws IOException;

    @Override
    public void refresh() throws RedshiftException {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            String jwt = this.getJwtAssertion();
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("JwtCredentialsProvider: refreshed JWT assertion of length={0}", jwt != null ? jwt.length() : -1);
            }
            Date expiration = new Date(System.currentTimeMillis() + 900000L);
            NativeTokenHolder credentials = NativeTokenHolder.newInstance(jwt, expiration);
            credentials.setRefresh(true);
            if (!this.m_disableCache.booleanValue()) {
                m_cache.put(this.getCacheKey(), credentials);
            } else {
                this.m_lastRefreshCredentials = credentials;
            }
        }
        catch (Exception e) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(e);
            }
            throw new RedshiftException("JWT error: " + e.getMessage(), e);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
    }

    @Override
    public String getPluginSpecificCacheKey() {
        return "";
    }

    @Override
    public String getIdpToken() throws RedshiftException {
        String jwt = null;
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CONTEXT_CLASS_LOADER);
        try {
            jwt = this.getJwtAssertion();
            if (RedshiftLogger.isEnable()) {
                this.m_log.logDebug("JwtCredentialsProvider: got JWT asssertion of length={0}", jwt != null ? jwt.length() : -1);
            }
        }
        catch (Exception e) {
            if (RedshiftLogger.isEnable()) {
                this.m_log.logError(e);
            }
            throw new RedshiftException("JWT error: " + e.getMessage(), e);
        }
        finally {
            currentThread.setContextClassLoader(cl);
        }
        return jwt;
    }

    @Override
    public String getCacheKey() {
        String pluginSpecificKey = this.getPluginSpecificCacheKey();
        return pluginSpecificKey;
    }
}

