/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PDFText2Markdown
extends PDFTextStripper {
    private final FontState fontState = new FontState();

    public PDFText2Markdown() throws IOException {
        this.setLineSeparator(this.LINE_SEPARATOR);
        this.setParagraphStart(this.LINE_SEPARATOR);
        this.setParagraphEnd(this.LINE_SEPARATOR);
        this.setPageStart(this.LINE_SEPARATOR);
        this.setPageEnd(this.LINE_SEPARATOR);
        this.setArticleStart(this.LINE_SEPARATOR);
        this.setArticleEnd(this.LINE_SEPARATOR);
    }

    private static String escape(String chars) {
        StringBuilder builder = new StringBuilder(chars.length());
        for (int i = 0; i < chars.length(); ++i) {
            PDFText2Markdown.appendEscaped(builder, chars.charAt(i));
        }
        return builder.toString();
    }

    private static void appendEscaped(StringBuilder builder, char character) {
        switch (character) {
            case '#': 
            case '*': 
            case '+': 
            case '-': {
                builder.append('\\').append(character);
                break;
            }
            case '\u00b2': {
                builder.append("<sup>2</sup>");
                break;
            }
            case '\u00b3': {
                builder.append("<sup>3</sup>");
                break;
            }
            default: {
                builder.append(character);
            }
        }
    }

    protected void startArticle(boolean isLTR) throws IOException {
        super.writeString(this.LINE_SEPARATOR);
    }

    protected void endArticle() throws IOException {
        super.endArticle();
        super.writeString(this.LINE_SEPARATOR);
    }

    protected void writeString(String text, List<TextPosition> textPositions) throws IOException {
        super.writeString(this.fontState.push(text, textPositions));
    }

    protected void writeString(String chars) throws IOException {
        super.writeString(PDFText2Markdown.escape(chars));
    }

    protected void writeParagraphEnd() throws IOException {
        super.writeString(this.fontState.clear());
        super.writeParagraphEnd();
    }

    private static class FontState {
        private final List<String> stateList = new ArrayList<String>();
        private final Set<String> stateSet = new HashSet<String>();

        private FontState() {
        }

        public String push(String text, List<TextPosition> textPositions) {
            StringBuilder buffer = new StringBuilder();
            if (text.length() == textPositions.size()) {
                for (int i = 0; i < text.length(); ++i) {
                    this.push(buffer, text.charAt(i), textPositions.get(i));
                }
            } else if (!text.isEmpty()) {
                if (textPositions.isEmpty()) {
                    return text;
                }
                this.push(buffer, text.charAt(0), textPositions.get(0));
                buffer.append(PDFText2Markdown.escape(text.substring(1)));
            }
            return buffer.toString();
        }

        public String clear() {
            StringBuilder buffer = new StringBuilder();
            this.closeUntil(buffer, null);
            this.stateList.clear();
            this.stateSet.clear();
            return buffer.toString();
        }

        protected String push(StringBuilder buffer, char character, TextPosition textPosition) {
            boolean bold = false;
            boolean italics = false;
            PDFontDescriptor descriptor = textPosition.getFont().getFontDescriptor();
            if (descriptor != null) {
                bold = this.isBold(descriptor);
                italics = this.isItalic(descriptor);
            }
            buffer.append(bold ? this.open("**") : this.close("**"));
            buffer.append(italics ? this.open("*") : this.close("*"));
            PDFText2Markdown.appendEscaped(buffer, character);
            return buffer.toString();
        }

        private String open(String tag) {
            if (this.stateSet.contains(tag)) {
                return "";
            }
            this.stateList.add(tag);
            this.stateSet.add(tag);
            return this.openTag(tag);
        }

        private String close(String tag) {
            int index;
            if (!this.stateSet.contains(tag)) {
                return "";
            }
            StringBuilder tagsBuilder = new StringBuilder();
            this.stateList.remove(index);
            this.stateSet.remove(tag);
            for (index = this.closeUntil(tagsBuilder, tag); index < this.stateList.size(); ++index) {
                tagsBuilder.append(this.openTag(this.stateList.get(index)));
            }
            return tagsBuilder.toString();
        }

        private int closeUntil(StringBuilder tagsBuilder, String endTag) {
            int i = this.stateList.size();
            while (i-- > 0) {
                String tag = this.stateList.get(i);
                tagsBuilder.append(this.closeTag(tag));
                if (endTag == null || !tag.equals(endTag)) continue;
                return i;
            }
            return -1;
        }

        private String openTag(String tag) {
            return tag;
        }

        private String closeTag(String tag) {
            return tag;
        }

        private boolean isBold(PDFontDescriptor descriptor) {
            if (descriptor.isForceBold()) {
                return true;
            }
            return descriptor.getFontName().toLowerCase().contains("bold");
        }

        private boolean isItalic(PDFontDescriptor descriptor) {
            if (descriptor.isItalic()) {
                return true;
            }
            String fontName = descriptor.getFontName().toLowerCase();
            return fontName.contains("italic") || fontName.contains("oblique");
        }
    }
}

