/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.flogger.util;

import com.google.common.flogger.util.Checks;
import com.google.common.flogger.util.StackGetter;
import java.util.function.Predicate;
import java.util.stream.Stream;

final class StackWalkerStackGetter
implements StackGetter {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.SHOW_REFLECT_FRAMES);

    StackWalkerStackGetter() {
    }

    @Override
    public StackTraceElement callerOf(Class<?> clazz, int n) {
        Checks.checkArgument(n >= 0, "skipFrames must be >= 0");
        return STACK_WALKER.walk(stream -> this.filterStackTraceAfterTarget(this.isTargetClass(clazz), n, (Stream<StackWalker.StackFrame>)stream).findFirst().orElse(null));
    }

    @Override
    public StackTraceElement[] getStackForCaller(Class<?> clazz, int n, int n2) {
        Checks.checkArgument(n == -1 || n > 0, "maxDepth must be > 0 or -1");
        Checks.checkArgument(n2 >= 0, "skipFrames must be >= 0");
        return STACK_WALKER.walk(stream -> (StackTraceElement[])this.filterStackTraceAfterTarget(this.isTargetClass(clazz), n2, (Stream<StackWalker.StackFrame>)stream).limit(n == -1 ? Long.MAX_VALUE : (long)n).toArray(StackTraceElement[]::new));
    }

    private Predicate<StackWalker.StackFrame> isTargetClass(Class<?> clazz) {
        String string = clazz.getName();
        return stackFrame -> stackFrame.getClassName().equals(string);
    }

    private Stream<StackTraceElement> filterStackTraceAfterTarget(Predicate<StackWalker.StackFrame> predicate, int n, Stream<StackWalker.StackFrame> stream) {
        return stream.skip(n + 1).dropWhile(predicate.negate()).dropWhile(predicate).map(StackWalker.StackFrame::toStackTraceElement);
    }
}

