/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.api.gax.retrying.RetryAlgorithm;
import com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.retrying.StreamingRetryAlgorithm;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.cloud.bigquery.storage.v1.BigQueryReadGrpc;
import com.google.cloud.bigquery.storage.v1.BigQueryReadSettings;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.EnhancedBigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.GrpcBigQueryReadStub;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ApiResultRetryAlgorithm;
import com.google.cloud.bigquery.storage.v1.stub.readrows.ReadRowsRetryingCallable;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class EnhancedBigQueryReadStub
implements BackgroundResource {
    private static final String TRACING_OUTER_CLIENT_NAME = "BigQueryStorage";
    private final GrpcBigQueryReadStub stub;
    private final BigQueryReadStubSettings stubSettings;
    private final BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener;
    private final ClientContext context;

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings) throws IOException {
        return EnhancedBigQueryReadStub.create(settings, null);
    }

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener) throws IOException {
        BigQueryReadStubSettings.Builder baseSettingsBuilder = (BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)BigQueryReadStubSettings.newBuilder().setUniverseDomain(settings.getUniverseDomain())).setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider())).setBackgroundExecutorProvider(settings.getBackgroundExecutorProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryReadStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create((StubSettings)baseSettings);
        GrpcBigQueryReadStub stub = new GrpcBigQueryReadStub(baseSettings, clientContext);
        return new EnhancedBigQueryReadStub(stub, baseSettings, readRowsRetryAttemptListener, clientContext);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryReadStub(GrpcBigQueryReadStub stub, BigQueryReadStubSettings stubSettings, BigQueryReadSettings.RetryAttemptListener readRowsRetryAttemptListener, ClientContext context) {
        this.stub = stub;
        this.stubSettings = stubSettings;
        this.readRowsRetryAttemptListener = readRowsRetryAttemptListener;
        this.context = context;
    }

    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        ServerStreamingCallable innerCallable = GrpcRawCallableFactory.createServerStreamingCallable((GrpcCallSettings)GrpcCallSettings.newBuilder().setMethodDescriptor(BigQueryReadGrpc.getReadRowsMethod()).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ReadRowsRequest>(){

            public Map<String, String> extract(ReadRowsRequest request) {
                return ImmutableMap.of((Object)"read_stream", (Object)String.valueOf(request.getReadStream()));
            }
        }).build(), (Set)this.stubSettings.readRowsSettings().getRetryableCodes());
        ServerStreamingCallSettings<ReadRowsRequest, ReadRowsResponse> callSettings = this.stubSettings.readRowsSettings();
        StreamingRetryAlgorithm retryAlgorithm = new StreamingRetryAlgorithm(new ApiResultRetryAlgorithm(this.readRowsRetryAttemptListener), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(callSettings.getRetrySettings(), this.context.getClock()));
        ScheduledRetryingExecutor retryingExecutor = new ScheduledRetryingExecutor((RetryAlgorithm)retryAlgorithm, this.context.getExecutor());
        if (this.context.getStreamWatchdog() != null) {
            innerCallable = Callables.watched((ServerStreamingCallable)innerCallable, callSettings, (ClientContext)this.context);
        }
        ReadRowsRetryingCallable outerCallable = new ReadRowsRetryingCallable(this.context.getDefaultCallContext(), (ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse>)innerCallable, (ScheduledRetryingExecutor<Void>)retryingExecutor, (StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse>)callSettings.getResumptionStrategy());
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable((ServerStreamingCallable)outerCallable, this.context.getTracerFactory(), SpanName.of((String)TRACING_OUTER_CLIENT_NAME, (String)"ReadRows"));
        return traced.withDefaultCallContext(this.context.getDefaultCallContext());
    }

    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    public void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public BigQueryReadStubSettings getStubSettings() {
        return this.stubSettings;
    }
}

