/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.AbstractModelComposite;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class MistralComposite
extends AbstractModelComposite {
    private final Label baseUrlLabel = this.createLabel();
    private final TextVar baseUrlInput = this.createTextVar();
    private final Label apiKeyLabel;
    private final TextVar apiKeyInput;
    private final Label modelNameLabel;
    private final TextVar modelNameInput;
    private final Label temperatureLabel;
    private final TextVar temperatureInput;
    private final Label topPLabel;
    private final TextVar topPInput;
    private final Label maxTokensLabel;
    private final TextVar maxTokensInput;
    private final Button safePromptButton;
    private final Label seedLabel;
    private final TextVar seedInput;
    private final Label responseFormatLabel;
    private final TextVar responseFormatInput;
    private final Label timeoutLabel;
    private final TextVar timeoutInput;
    private final Button logRequestsButton;
    private final Button logResponsesButton;
    private final Label maxRetriesLabel;
    private final TextVar maxRetriesInput;

    public MistralComposite(CompositeParameters parameters) {
        super(ModelType.MISTRAL, parameters);
        this.prepare("BaseUrl", this.baseUrlLabel, (Control)this.baseUrlInput);
        this.apiKeyLabel = this.createLabel();
        this.apiKeyInput = this.createTextVar();
        this.prepare("ApiKey", this.apiKeyLabel, (Control)this.apiKeyInput);
        this.modelNameLabel = this.createLabel();
        this.modelNameInput = this.createTextVar();
        this.prepare("ModelName", this.modelNameLabel, (Control)this.modelNameInput);
        this.temperatureLabel = this.createLabel();
        this.temperatureInput = this.createTextVar();
        this.prepare("Temperature", this.temperatureLabel, (Control)this.temperatureInput);
        this.topPLabel = this.createLabel();
        this.topPInput = this.createTextVar();
        this.prepare("TopP", this.topPLabel, (Control)this.topPInput);
        this.maxTokensLabel = this.createLabel();
        this.maxTokensInput = this.createTextVar();
        this.prepare("MaxTokens", this.maxTokensLabel, (Control)this.maxTokensInput);
        this.safePromptButton = this.createButton();
        this.prepare("SafePrompt", null, (Control)this.safePromptButton);
        this.seedLabel = this.createLabel();
        this.seedInput = this.createTextVar();
        this.prepare("Seed", this.seedLabel, (Control)this.seedInput);
        this.responseFormatLabel = this.createLabel();
        this.responseFormatInput = this.createTextVar();
        this.prepare("ResponseFormat", this.responseFormatLabel, (Control)this.responseFormatInput);
        this.timeoutLabel = this.createLabel();
        this.timeoutInput = this.createTextVar();
        this.prepare("Timeout", this.timeoutLabel, (Control)this.timeoutInput);
        this.logRequestsButton = this.createButton();
        this.prepare("LogRequests", null, (Control)this.logRequestsButton);
        this.logResponsesButton = this.createButton();
        this.prepare("LogResponses", null, (Control)this.logResponsesButton);
        this.maxRetriesLabel = this.createLabel();
        this.maxRetriesInput = this.createTextVar();
        this.prepare("MaxRetries", this.maxRetriesLabel, (Control)this.maxRetriesInput);
    }

    @Override
    public void loadData() {
        if (!this.isSelectedModelType()) {
            return;
        }
        if (this.meta.getMistralBaseUrl() != null) {
            this.baseUrlInput.setText(this.meta.getMistralBaseUrl());
        }
        if (this.meta.getMistralApiKey() != null) {
            this.apiKeyInput.setText(this.meta.getMistralApiKey());
        }
        if (this.meta.getMistralModelName() != null) {
            this.modelNameInput.setText(this.meta.getMistralModelName());
        }
        if (this.meta.getMistralTemperature() != null) {
            this.temperatureInput.setText("" + this.meta.getMistralTemperature());
        }
        if (this.meta.getMistralTopP() != null) {
            this.topPInput.setText("" + this.meta.getMistralTopP());
        }
        if (this.meta.getMistralMaxTokens() != null) {
            this.maxTokensInput.setText("" + this.meta.getMistralMaxTokens());
        }
        this.safePromptButton.setSelection(this.meta.isMistralSafePrompt());
        if (this.meta.getMistralRandomSeed() != null) {
            this.seedInput.setText("" + this.meta.getMistralRandomSeed());
        }
        if (this.meta.getMistralResponseFormat() != null) {
            this.responseFormatInput.setText(this.meta.getMistralResponseFormat());
        }
        if (this.meta.getMistralTimeout() != null) {
            this.timeoutInput.setText("" + this.meta.getMistralTimeout());
        }
        this.logRequestsButton.setSelection(this.meta.isMistralLogRequests());
        this.logResponsesButton.setSelection(this.meta.isMistralLogResponses());
        if (this.meta.getMistralMaxRetries() != null) {
            this.maxRetriesInput.setText("" + this.meta.getMistralMaxRetries());
        }
    }

    @Override
    public boolean validateInputs() {
        if (!this.isSelectedModelType()) {
            return true;
        }
        String temperature = StringUtils.trim((String)this.temperatureInput.getText());
        return StringUtils.isBlank((CharSequence)temperature) || NumberUtils.isCreatable((String)temperature);
    }

    @Override
    public void updateTransformMeta() {
        if (!this.validateInputs()) {
            return;
        }
        this.meta.setMistralBaseUrl(this.trimStringToNull(this.baseUrlInput.getText()));
        this.meta.setMistralApiKey(this.trimStringToNull(this.apiKeyInput.getText()));
        this.meta.setMistralModelName(this.trimStringToNull(this.modelNameInput.getText()));
        this.meta.setMistralTemperature(this.trimDoubleToNull(this.temperatureInput.getText()));
        this.meta.setMistralTopP(this.trimDoubleToNull(this.topPInput.getText()));
        this.meta.setMistralMaxTokens(this.trimIntegerToNull(this.maxTokensInput.getText()));
        this.meta.setMistralSafePrompt(this.safePromptButton.getSelection());
        this.meta.setMistralRandomSeed(this.trimIntegerToNull(this.seedInput.getText()));
        this.meta.setMistralResponseFormat(this.trimStringToNull(this.responseFormatInput.getText()));
        this.meta.setMistralTimeout(this.trimIntegerToNull(this.timeoutInput.getText()));
        this.meta.setMistralLogRequests(this.logRequestsButton.getSelection());
        this.meta.setMistralLogResponses(this.logResponsesButton.getSelection());
        this.meta.setMistralMaxRetries(this.trimIntegerToNull(this.maxRetriesInput.getText()));
    }

    public Label getApiKeyLabel() {
        return this.apiKeyLabel;
    }

    public TextVar getApiKeyInput() {
        return this.apiKeyInput;
    }

    public Label getModelNameLabel() {
        return this.modelNameLabel;
    }

    public TextVar getModelNameInput() {
        return this.modelNameInput;
    }

    public Label getTemperatureLabel() {
        return this.temperatureLabel;
    }

    public TextVar getTemperatureInput() {
        return this.temperatureInput;
    }

    public Label getBaseUrlLabel() {
        return this.baseUrlLabel;
    }

    public TextVar getBaseUrlInput() {
        return this.baseUrlInput;
    }

    public Button getSafePromptButton() {
        return this.safePromptButton;
    }

    public Label getTopPLabel() {
        return this.topPLabel;
    }

    public TextVar getTopPInput() {
        return this.topPInput;
    }

    public Label getMaxTokensLabel() {
        return this.maxTokensLabel;
    }

    public TextVar getMaxTokensInput() {
        return this.maxTokensInput;
    }

    public Label getResponseFormatLabel() {
        return this.responseFormatLabel;
    }

    public TextVar getResponseFormatInput() {
        return this.responseFormatInput;
    }

    public Label getSeedLabel() {
        return this.seedLabel;
    }

    public TextVar getSeedInput() {
        return this.seedInput;
    }

    public Label getTimeoutLabel() {
        return this.timeoutLabel;
    }

    public TextVar getTimeoutInput() {
        return this.timeoutInput;
    }

    public Label getMaxRetriesLabel() {
        return this.maxRetriesLabel;
    }

    public TextVar getMaxRetriesInput() {
        return this.maxRetriesInput;
    }

    public Button getLogRequestsButton() {
        return this.logRequestsButton;
    }

    public Button getLogResponsesButton() {
        return this.logResponsesButton;
    }
}

