/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.exception.UcanaccessRuntimeException;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.ExecuteUpdate;
import net.ucanaccess.jdbc.NormalizedSQL;
import net.ucanaccess.jdbc.UcanaccessBlob;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessStatement;
import net.ucanaccess.util.Try;

public class UcanaccessPreparedStatement
extends UcanaccessStatement
implements PreparedStatement {
    private PreparedStatement wrapped;
    private String sql;
    private final Map<Integer, ParameterReset> memento = new HashMap<Integer, ParameterReset>();

    public UcanaccessPreparedStatement(NormalizedSQL _nsql, PreparedStatement _hidden, UcanaccessConnection _conn) throws SQLException {
        super(_hidden, _conn);
        this.sql = _nsql.getSql();
        this.setAliases(_nsql.getAliases());
        this.wrapped = _hidden;
        if (_hidden == null) {
            ((UcanaccessStatement)this).wrapped = _conn.createStatement();
        }
    }

    public UcanaccessPreparedStatement(String _sql, UcanaccessConnection _connection) throws SQLException {
        super(null, _connection);
        this.sql = _sql;
        ((UcanaccessStatement)this).wrapped = _connection.createStatement();
    }

    private void addMementoEntry(String methodName, Class<?>[] argClasses, Object ... args) {
        Class[] ac = new Class[args.length];
        ac[0] = Integer.TYPE;
        System.arraycopy(argClasses, 0, ac, 1, ac.length - 1);
        this.memento.put((Integer)args[0], new ParameterReset(methodName, ac, args));
    }

    private void parametersReset() {
        for (ParameterReset pr : this.memento.values()) {
            pr.execute();
        }
    }

    private Reader markableReader(Reader r) throws UcanaccessSQLException {
        return this.markableReader(r, -1L);
    }

    private Reader markableReader(Reader r, long l) throws UcanaccessSQLException {
        if (r.markSupported() && l < 0L) {
            boolean marked = true;
            try {
                r.mark(1000000);
            }
            catch (IOException _ex) {
                marked = false;
            }
            if (marked) {
                return r;
            }
        }
        StringBuilder sb = new StringBuilder();
        int dim = l >= 0L ? (int)l : 4096;
        char[] cb = new char[dim];
        return UcanaccessPreparedStatement.tryCatch(() -> {
            int rd;
            while ((rd = r.read(cb)) >= 0) {
                sb.append(Arrays.copyOf(cb, rd));
                if (l < 0L) continue;
            }
            StringReader sr = new StringReader(sb.toString());
            sr.mark(1000000);
            return sr;
        });
    }

    private InputStream markableInputStream(InputStream is) throws UcanaccessSQLException {
        return this.markableInputStream(is, -1L);
    }

    private InputStream markableInputStream(InputStream is, long l) throws UcanaccessSQLException {
        if (is.markSupported() && l < 0L) {
            is.mark(1000000);
            return is;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int dim = l >= 0L ? (int)l : 4096;
        byte[] buffer = new byte[dim];
        try {
            int rd;
            while ((rd = is.read(buffer)) >= 0) {
                bos.write(buffer, 0, rd);
                if (l < 0L) continue;
            }
            bos.flush();
            ByteArrayInputStream ir = new ByteArrayInputStream(bos.toByteArray());
            ir.mark(1000000);
            return ir;
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    private void resetReader(Reader r) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(r::reset);
    }

    private void resetInputStream(InputStream is) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(is::reset);
    }

    private void preprocess() throws UcanaccessSQLException {
        if (SQLConverter.hasIdentity(this.sql)) {
            this.sql = SQLConverter.preprocess(this.sql, this.getConnection().getLastGeneratedKey());
            this.reset();
        }
    }

    @Override
    public void addBatch() throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> this.wrapped.addBatch());
    }

    @Override
    public void clearParameters() throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.memento.clear();
            this.wrapped.clearParameters();
        });
    }

    @Override
    public boolean execute() throws UcanaccessSQLException {
        return UcanaccessPreparedStatement.tryCatch(() -> {
            if (this.wrapped == null) {
                return ((UcanaccessStatement)this).wrapped.execute(this.sql);
            }
            this.preprocess();
            this.getConnection().setCurrentStatement(this);
            this.checkLastModified();
            return new Execute(this).execute();
        });
    }

    @Override
    public ResultSet executeQuery() throws UcanaccessSQLException {
        return UcanaccessPreparedStatement.tryCatch(() -> {
            this.preprocess();
            this.getConnection().setCurrentStatement(this);
            this.checkLastModified();
            return new UcanaccessResultSet(this.wrapped.executeQuery(), this);
        });
    }

    @Override
    public int executeUpdate() throws UcanaccessSQLException {
        return UcanaccessPreparedStatement.tryCatch(() -> {
            if (this.wrapped == null) {
                return ((UcanaccessStatement)this).wrapped.executeUpdate(this.sql);
            }
            this.preprocess();
            this.getConnection().setCurrentStatement(this);
            this.checkLastModified();
            return new ExecuteUpdate(this).execute();
        });
    }

    @Override
    public ResultSetMetaData getMetaData() throws UcanaccessSQLException {
        return UcanaccessPreparedStatement.tryCatch(this.wrapped::getMetaData);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws UcanaccessSQLException {
        return UcanaccessPreparedStatement.tryCatch(this.wrapped::getParameterMetaData);
    }

    @Override
    public void setArray(int _parmIdx, Array array) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setArray", new Class[]{Array.class}, _parmIdx, array);
            this.wrapped.setArray(_parmIdx, array);
        });
    }

    @Override
    public void setAsciiStream(int _parmIdx, InputStream is) throws UcanaccessSQLException {
        try {
            is = this.markableInputStream(is);
            this.addMementoEntry("setAsciiStream", new Class[]{InputStream.class}, _parmIdx, is);
            this.wrapped.setAsciiStream(_parmIdx, is);
            this.resetInputStream(is);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setAsciiStream(int _parmIdx, InputStream is, int length) throws UcanaccessSQLException {
        try {
            is = this.markableInputStream(is, length);
            this.addMementoEntry("setAsciiStream", new Class[]{InputStream.class, Integer.TYPE}, _parmIdx, is, length);
            this.wrapped.setAsciiStream(_parmIdx, is, length);
            this.resetInputStream(is);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setAsciiStream(int _parmIdx, InputStream is, long length) throws UcanaccessSQLException {
        try {
            is = this.markableInputStream(is, length);
            this.addMementoEntry("setAsciiStream", new Class[]{InputStream.class, Long.TYPE}, _parmIdx, is, length);
            this.wrapped.setAsciiStream(_parmIdx, is, length);
            this.resetInputStream(is);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setBigDecimal(int _parmIdx, BigDecimal dec) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBigDecimal", new Class[]{BigDecimal.class}, _parmIdx, dec);
            this.wrapped.setBigDecimal(_parmIdx, dec);
        });
    }

    @Override
    public void setBinaryStream(int _parmIdx, InputStream is) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBinaryStream", new Class[]{InputStream.class}, _parmIdx, is);
            this.wrapped.setBinaryStream(_parmIdx, is);
        });
    }

    @Override
    public void setBinaryStream(int _parmIdx, InputStream is, int length) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBinaryStream", new Class[]{InputStream.class, Integer.TYPE}, _parmIdx, is, length);
            this.wrapped.setBinaryStream(_parmIdx, is, length);
        });
    }

    @Override
    public void setBinaryStream(int _parmIdx, InputStream is, long length) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBinaryStream", new Class[]{InputStream.class, Long.TYPE}, _parmIdx, is, length);
            this.wrapped.setBinaryStream(_parmIdx, is, length);
        });
    }

    @Override
    public void setBlob(int _parmIdx, Blob blob) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBlob", new Class[]{Blob.class}, _parmIdx, blob);
            this.wrapped.setBlob(_parmIdx, blob);
        });
    }

    @Override
    public void setBlob(int _parmIdx, InputStream is) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBlob", new Class[]{InputStream.class}, _parmIdx, is);
            this.wrapped.setBlob(_parmIdx, is);
        });
    }

    @Override
    public void setBlob(int _parmIdx, InputStream is, long length) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBlob", new Class[]{InputStream.class, Long.TYPE}, _parmIdx, is, length);
            this.wrapped.setBlob(_parmIdx, is, length);
        });
    }

    @Override
    public void setBoolean(int _parmIdx, boolean bool) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBoolean", new Class[]{Boolean.TYPE}, _parmIdx, bool);
            this.wrapped.setBoolean(_parmIdx, bool);
        });
    }

    @Override
    public void setByte(int _parmIdx, byte b) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setByte", new Class[]{Byte.TYPE}, _parmIdx, b);
            this.wrapped.setByte(_parmIdx, b);
        });
    }

    @Override
    public void setBytes(int _parmIdx, byte[] bytes) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setBytes", new Class[]{byte[].class}, _parmIdx, bytes);
            this.wrapped.setBytes(_parmIdx, bytes);
        });
    }

    @Override
    public void setCharacterStream(int _parmIdx, Reader reader) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setCharacterStream", new Class[]{Reader.class}, _parmIdx, reader);
            this.wrapped.setCharacterStream(_parmIdx, reader);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setCharacterStream(int _parmIdx, Reader reader, int length) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setCharacterStream", new Class[]{Reader.class, Integer.TYPE}, _parmIdx, reader, length);
            this.wrapped.setCharacterStream(_parmIdx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setCharacterStream(int _parmIdx, Reader reader, long length) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setCharacterStream", new Class[]{Reader.class, Long.TYPE}, _parmIdx, reader, length);
            this.wrapped.setCharacterStream(_parmIdx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setClob(int _parmIdx, Clob clob) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setClob", new Class[]{Clob.class}, _parmIdx, clob);
            this.wrapped.setClob(_parmIdx, clob);
        });
    }

    @Override
    public void setClob(int _parmIdx, Reader reader) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setClob", new Class[]{Reader.class}, _parmIdx, reader);
            this.wrapped.setClob(_parmIdx, reader);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setClob(int _parmIdx, Reader reader, long length) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setClob", new Class[]{Reader.class, Long.TYPE}, _parmIdx, reader, length);
            this.wrapped.setClob(_parmIdx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setCursorName(String _name) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> this.wrapped.setCursorName(_name));
    }

    @Override
    public void setDate(int _parmIdx, Date date) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setDate", new Class[]{Date.class}, _parmIdx, date);
            this.wrapped.setDate(_parmIdx, date);
        });
    }

    @Override
    public void setDate(int _parmIdx, Date date, Calendar cal) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setDate", new Class[]{Date.class, Calendar.class}, _parmIdx, date, cal);
            this.wrapped.setDate(_parmIdx, date, cal);
        });
    }

    @Override
    public void setDouble(int _parmIdx, double d) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setDouble", new Class[]{Double.TYPE}, _parmIdx, d);
            this.wrapped.setDouble(_parmIdx, d);
        });
    }

    @Override
    public void setFloat(int _parmIdx, float f) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setFloat", new Class[]{Float.TYPE}, _parmIdx, Float.valueOf(f));
            this.wrapped.setBigDecimal(_parmIdx, new BigDecimal(Float.toString(f)));
        });
    }

    @Override
    public void setInt(int _parmIdx, int i) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setInt", new Class[]{Integer.TYPE}, _parmIdx, i);
            this.wrapped.setInt(_parmIdx, i);
        });
    }

    @Override
    public void setLong(int _parmIdx, long l) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setLong", new Class[]{Long.TYPE}, _parmIdx, l);
            this.wrapped.setLong(_parmIdx, l);
        });
    }

    @Override
    public void setNCharacterStream(int _parmIdx, Reader reader) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setNCharacterStream", new Class[]{Reader.class}, _parmIdx, reader);
            this.wrapped.setNCharacterStream(_parmIdx, reader);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setNCharacterStream(int _parmIdx, Reader reader, long l) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader, l);
            this.addMementoEntry("setNCharacterStream", new Class[]{Reader.class, Long.TYPE}, _parmIdx, reader, l);
            this.wrapped.setNCharacterStream(_parmIdx, reader, l);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setNClob(int _parmIdx, NClob nclob) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setNClob", new Class[]{NClob.class}, _parmIdx, nclob);
            this.wrapped.setNClob(_parmIdx, nclob);
        });
    }

    @Override
    public void setNClob(int _parmIdx, Reader reader) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader);
            this.addMementoEntry("setNClob", new Class[]{Reader.class}, _parmIdx, reader);
            this.wrapped.setNClob(_parmIdx, reader);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setNClob(int _parmIdx, Reader reader, long length) throws UcanaccessSQLException {
        try {
            reader = this.markableReader(reader, length);
            this.addMementoEntry("setNClob", new Class[]{Reader.class, Long.TYPE}, _parmIdx, reader, length);
            this.wrapped.setNClob(_parmIdx, reader, length);
            this.resetReader(reader);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setNString(int _parmIdx, String string) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setNString", new Class[]{String.class}, _parmIdx, string);
            this.wrapped.setNString(_parmIdx, string);
        });
    }

    @Override
    public void setNull(int _parmIdx, int sqlt) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setNull", new Class[]{Integer.TYPE}, _parmIdx, sqlt);
            this.wrapped.setNull(_parmIdx, sqlt);
        });
    }

    @Override
    public void setNull(int _parmIdx, int sqlt, String tn) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setNull", new Class[]{Integer.TYPE, String.class}, _parmIdx, sqlt, tn);
            this.wrapped.setNull(_parmIdx, sqlt, tn);
        });
    }

    private Object mapLocalTimeToLocalDateTime(Object _x) {
        if (_x instanceof LocalTime) {
            return ((LocalTime)_x).atDate(LocalDate.of(1899, 12, 30));
        }
        return _x;
    }

    private Object mapToBlob(Object x) throws UcanaccessSQLException {
        return UcanaccessPreparedStatement.tryCatch(() -> x instanceof File ? UcanaccessBlob.createBlob((File)x, this.getConnection()) : x);
    }

    @Override
    public void setObject(int _parmIdx, Object x) throws UcanaccessSQLException {
        x = this.mapToBlob(this.mapLocalTimeToLocalDateTime(x));
        try {
            if (x instanceof Float) {
                this.setFloat(_parmIdx, ((Float)x).floatValue());
            } else {
                this.addMementoEntry("setObject", new Class[]{Object.class}, _parmIdx, x);
                this.wrapped.setObject(_parmIdx, x);
            }
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setObject(int _parmIdx, Object _obj, int tsqlt) throws UcanaccessSQLException {
        Object obj = this.mapToBlob(this.mapLocalTimeToLocalDateTime(_obj));
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setObject", new Class[]{Object.class, Integer.TYPE}, _parmIdx, obj, tsqlt);
            this.wrapped.setObject(_parmIdx, obj, tsqlt);
        });
    }

    @Override
    public void setObject(int _parmIdx, Object _obj, int tsqlt, int sol) throws UcanaccessSQLException {
        Object obj = this.mapToBlob(this.mapLocalTimeToLocalDateTime(_obj));
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setObject", new Class[]{Object.class, Integer.TYPE, Integer.TYPE}, _parmIdx, obj, tsqlt, sol);
            this.wrapped.setObject(_parmIdx, obj, tsqlt, sol);
        });
    }

    @Override
    public void setRef(int _parmIdx, Ref ref) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setRef", new Class[]{Ref.class}, _parmIdx, ref);
            this.wrapped.setRef(_parmIdx, ref);
        });
    }

    @Override
    public void setRowId(int _parmIdx, RowId rowId) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setRowId", new Class[]{RowId.class}, _parmIdx, rowId);
            this.wrapped.setRowId(_parmIdx, rowId);
        });
    }

    @Override
    public void setShort(int _parmIdx, short sht) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setShort", new Class[]{Short.TYPE}, _parmIdx, sht);
            this.wrapped.setShort(_parmIdx, sht);
        });
    }

    @Override
    public void setSQLXML(int _parmIdx, SQLXML sx) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setSQLXML", new Class[]{SQLXML.class}, _parmIdx, sx);
            this.wrapped.setSQLXML(_parmIdx, sx);
        });
    }

    @Override
    public void setString(int _parmIdx, String string) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setString", new Class[]{String.class}, _parmIdx, string);
            this.wrapped.setString(_parmIdx, string);
        });
    }

    @Override
    public void setTime(int _parmIdx, Time time) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            Calendar cl = Calendar.getInstance();
            cl.setTime(time);
            cl.set(1899, 11, 30);
            cl.set(14, 0);
            Timestamp ts = new Timestamp(cl.getTimeInMillis());
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class}, _parmIdx, ts);
            this.wrapped.setTimestamp(_parmIdx, ts);
        });
    }

    @Override
    public void setTime(int _parmIdx, Time time, Calendar cal) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            Calendar cl = Calendar.getInstance();
            cal.setTime(time);
            cl.set(1899, 11, 30, cal.get(11), cal.get(12), cal.get(13));
            cl.set(14, 0);
            Timestamp ts = new Timestamp(cl.getTimeInMillis());
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class}, _parmIdx, ts);
            this.wrapped.setTimestamp(_parmIdx, ts);
        });
    }

    @Override
    public void setTimestamp(int _parmIdx, Timestamp ts) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class}, _parmIdx, ts);
            this.wrapped.setTimestamp(_parmIdx, ts);
        });
    }

    @Override
    public void setTimestamp(int _parmIdx, Timestamp ts, Calendar cal) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            this.addMementoEntry("setTimestamp", new Class[]{Timestamp.class, Calendar.class}, _parmIdx, ts, cal);
            this.wrapped.setTimestamp(_parmIdx, ts, cal);
        });
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int _parmIdx, InputStream is, int length) throws UcanaccessSQLException {
        try {
            is = this.markableInputStream(is, length);
            this.addMementoEntry("setUnicodeStream", new Class[]{InputStream.class, Integer.TYPE}, _parmIdx, is, length);
            this.wrapped.setUnicodeStream(_parmIdx, is, length);
            this.resetInputStream(is);
        }
        catch (SQLException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public void setURL(int _parmIdx, URL url) throws UcanaccessSQLException {
        UcanaccessPreparedStatement.tryCatch(() -> {
            String arg = "#" + url.toString() + "#";
            this.addMementoEntry("setString", new Class[]{String.class}, _parmIdx, arg);
            this.wrapped.setString(_parmIdx, arg);
        });
    }

    @Override
    public <T> T unwrap(Class<T> _iface) throws UcanaccessSQLException {
        return (T)UcanaccessPreparedStatement.tryCatch(() -> this.wrapped.unwrap(_iface));
    }

    @Override
    protected void reset() throws UcanaccessSQLException {
        if (this.wrapped == null) {
            return;
        }
        PreparedStatement old = this.wrapped;
        this.wrapped = UcanaccessPreparedStatement.tryCatch(() -> this.getConnection().getHSQLDBConnection().prepareStatement(this.sql, this.wrapped.getResultSetType(), this.wrapped.getResultSetConcurrency(), this.wrapped.getResultSetHoldability()));
        this.reset(this.wrapped);
        this.parametersReset();
        UcanaccessPreparedStatement.tryCatch(old::close);
    }

    private final class ParameterReset {
        private final String methodName;
        private final Object[] args;
        private final Class<?>[] argClasses;

        private ParameterReset(String _methodName, Class<?>[] _argClasses, Object ... _args) {
            this.methodName = _methodName;
            this.args = _args;
            this.argClasses = _argClasses;
        }

        void execute() {
            Try.catching(() -> {
                Method mth = PreparedStatement.class.getDeclaredMethod(this.methodName, this.argClasses);
                mth.invoke((Object)UcanaccessPreparedStatement.this.wrapped, this.args);
                if (this.args[1] instanceof StringReader) {
                    StringReader sr = (StringReader)this.args[1];
                    sr.reset();
                }
                if (this.args[1] instanceof InputStream && ("setAsciiStream".equals(this.methodName) || "setUnicodeStream".equals(this.methodName))) {
                    ((InputStream)this.args[1]).reset();
                }
            }).orThrow(UcanaccessRuntimeException::new);
        }
    }
}

