/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.util.Collections;
import java.util.List;
import org.apache.tika.parser.mp3.ID3Tags;

public class CompositeTagHandler
implements ID3Tags {
    private ID3Tags[] tags;

    public CompositeTagHandler(ID3Tags[] tags) {
        this.tags = tags;
    }

    @Override
    public boolean getTagsPresent() {
        for (ID3Tags tag : this.tags) {
            if (!tag.getTagsPresent()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        for (ID3Tags tag : this.tags) {
            if (tag.getTitle() == null) continue;
            return tag.getTitle();
        }
        return null;
    }

    @Override
    public String getArtist() {
        for (ID3Tags tag : this.tags) {
            if (tag.getArtist() == null) continue;
            return tag.getArtist();
        }
        return null;
    }

    @Override
    public String getAlbum() {
        for (ID3Tags tag : this.tags) {
            if (tag.getAlbum() == null) continue;
            return tag.getAlbum();
        }
        return null;
    }

    @Override
    public String getComposer() {
        for (ID3Tags tag : this.tags) {
            if (tag.getComposer() == null) continue;
            return tag.getComposer();
        }
        return null;
    }

    @Override
    public String getYear() {
        for (ID3Tags tag : this.tags) {
            if (tag.getYear() == null) continue;
            return tag.getYear();
        }
        return null;
    }

    @Override
    public List<ID3Tags.ID3Comment> getComments() {
        for (ID3Tags tag : this.tags) {
            List<ID3Tags.ID3Comment> comments = tag.getComments();
            if (comments == null || comments.size() <= 0) continue;
            return comments;
        }
        return Collections.emptyList();
    }

    @Override
    public String getGenre() {
        for (ID3Tags tag : this.tags) {
            if (tag.getGenre() == null) continue;
            return tag.getGenre();
        }
        return null;
    }

    @Override
    public String getTrackNumber() {
        for (ID3Tags tag : this.tags) {
            if (tag.getTrackNumber() == null) continue;
            return tag.getTrackNumber();
        }
        return null;
    }

    @Override
    public String getAlbumArtist() {
        for (ID3Tags tag : this.tags) {
            if (tag.getAlbumArtist() == null) continue;
            return tag.getAlbumArtist();
        }
        return null;
    }

    @Override
    public String getDisc() {
        for (ID3Tags tag : this.tags) {
            if (tag.getDisc() == null) continue;
            return tag.getDisc();
        }
        return null;
    }

    @Override
    public String getCompilation() {
        for (ID3Tags tag : this.tags) {
            if (tag.getCompilation() == null) continue;
            return tag.getCompilation();
        }
        return null;
    }
}

