/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.as400command;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.CommandCall;
import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;

@Action(id="AS400Command", name="i18n::ActionAs400Command.Name", description="i18n::ActionAs400Command.Description", image="as400command.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", keywords={"i18n::ActionAs400Command.keyword"}, documentationUrl="/workflow/actions/as400command.html", isIncludeJdbcDrivers=true)
public class ActionAs400Command
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionAs400Command.class;
    private static final String TAG_SERVER = "server";
    private static final String TAG_USER = "user";
    private static final String TAG_PASSWORD = "password";
    private static final String TAG_COMMAND = "command";
    @HopMetadataProperty(key="server")
    private String server;
    @HopMetadataProperty(key="user")
    private String user;
    @HopMetadataProperty(key="password", password=true)
    private String password;
    @HopMetadataProperty(key="command")
    private String command;
    @HopMetadataProperty(key="proxyHost")
    private String proxyHost;
    @HopMetadataProperty(key="proxyPort")
    private String proxyPort;

    public ActionAs400Command(String name, String description) {
        super(name, description);
        this.server = null;
        this.user = null;
        this.password = null;
        this.proxyHost = null;
        this.proxyPort = null;
        this.command = null;
    }

    public ActionAs400Command() {
        this("", "");
    }

    public ActionAs400Command(ActionAs400Command other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.server = other.server;
        this.user = other.user;
        this.password = other.password;
        this.proxyHost = other.proxyHost;
        this.proxyPort = other.proxyPort;
        this.command = other.command;
    }

    public Object clone() {
        return new ActionAs400Command(this);
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String userName) {
        this.user = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String serverName) {
        this.server = serverName;
    }

    protected String getProxyServer(String host, String port) {
        Object proxyServer = "";
        if (!Utils.isEmpty((CharSequence)host)) {
            proxyServer = this.resolve(port);
            if (!Utils.isEmpty((CharSequence)port)) {
                proxyServer = (String)proxyServer + ":" + this.resolve(port);
            }
        }
        return proxyServer;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String value) {
        this.proxyPort = value;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result result, int nr) throws HopException {
        AS400 system = null;
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.Started", (String[])new String[0]));
        }
        String serverString = this.resolve(this.server);
        String userString = this.resolve(this.user);
        String passwordString = Utils.resolvePassword((IVariables)this, (String)this.password);
        String commandString = this.resolve(this.command);
        try {
            CommandCall command;
            String proxyServer = this.getProxyServer(this.resolve(this.proxyHost), this.resolve(this.proxyPort));
            if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.Connecting", (String[])new String[]{serverString, userString}));
            }
            system = new AS400(serverString, userString, passwordString, proxyServer);
            if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.Connected", (String[])new String[]{serverString}));
            }
            if (this.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.CommandRun", (String[])new String[]{commandString}));
            }
            if ((command = new CommandCall(system)).run(commandString)) {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.CommandSuccess", (String[])new String[]{serverString, commandString}));
                }
                result.setNrErrors(0L);
                result.setResult(true);
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.CommandFailed", (String[])new String[]{serverString, commandString}));
                for (AS400Message message : command.getMessageList()) {
                    this.logError(message.getID() + ":" + message.getText());
                    this.logError(message.getHelp());
                }
                result.setNrErrors(1L);
                result.setResult(false);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionAs400Command.Log.CommandFailed", (String[])new String[]{serverString, commandString}), e);
            result.setNrErrors(1L);
            result.setResult(false);
        }
        finally {
            try {
                system.disconnectService(2);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.server)) {
            String realServername = variables.resolve(this.server);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public boolean test(IVariables variables, String server, String user, String password, String proxyHost, String proxyPort) throws Exception {
        String proxyServer = this.getProxyServer(variables.resolve(proxyHost), variables.resolve(proxyPort));
        AS400 system = new AS400(variables.resolve(server), variables.resolve(user), Utils.resolvePassword((IVariables)this, (String)password), proxyServer);
        system.connectService(2);
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, TAG_SERVER, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, TAG_USER, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, TAG_PASSWORD, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, TAG_COMMAND, remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

