/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ifnull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.ifnull.Field;
import org.apache.hop.pipeline.transforms.ifnull.IfNullMeta;
import org.apache.hop.pipeline.transforms.ifnull.ValueType;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IfNullDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = IfNullMeta.class;
    public static final String CONST_SYSTEM_COMBO_YES = "System.Combo.Yes";
    public static final String CONST_SYSTEM_COMBO_NO = "System.Combo.No";
    private final IfNullMeta input;
    private int fieldsRows = 0;
    private ModifyListener oldlsMod;
    private int margin;
    private IRowMeta prevFields = null;
    private final List<ColumnInfo> fieldColumns = new ArrayList<ColumnInfo>();
    private Button wSelectFields;
    private Button wSelectValuesType;
    private Label wlFields;
    private Label wlValueTypes;
    private TableView wFields;
    private TableView wValueTypes;
    private Label wlReplaceByValue;
    private TextVar wReplaceByValue;
    private Label wlMask;
    private CCombo wMask;
    private Label wlSetEmptyStringAll;
    private Button wSetEmptyStringAll;

    public IfNullDialog(Shell parent, IVariables variables, IfNullMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        this.oldlsMod = lsMod;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        int middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.fieldsRows = this.input.getFields().size();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.Shell.Title", (String[])new String[0]));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wAllFields = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wAllFields);
        wAllFields.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.AllFields.Label", (String[])new String[0]));
        FormLayout allFieldsgroupLayout = new FormLayout();
        allFieldsgroupLayout.marginWidth = 10;
        allFieldsgroupLayout.marginHeight = 10;
        wAllFields.setLayout((Layout)allFieldsgroupLayout);
        this.wlReplaceByValue = new Label((Composite)wAllFields, 131072);
        this.wlReplaceByValue.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.ReplaceByValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlReplaceByValue);
        FormData fdlReplaceByValue = new FormData();
        fdlReplaceByValue.left = new FormAttachment(0, 0);
        fdlReplaceByValue.right = new FormAttachment(middle, -this.margin);
        fdlReplaceByValue.top = new FormAttachment((Control)this.wTransformName, this.margin * 2);
        this.wlReplaceByValue.setLayoutData((Object)fdlReplaceByValue);
        this.wReplaceByValue = new TextVar(this.variables, (Composite)wAllFields, 18436);
        this.wReplaceByValue.setToolTipText(BaseMessages.getString(PKG, (String)"IfNullDialog.ReplaceByValue.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wReplaceByValue);
        FormData fdReplaceByValue = new FormData();
        fdReplaceByValue.left = new FormAttachment(middle, 0);
        fdReplaceByValue.top = new FormAttachment((Control)this.wTransformName, 2 * this.margin);
        fdReplaceByValue.right = new FormAttachment(100, 0);
        this.wReplaceByValue.setLayoutData((Object)fdReplaceByValue);
        this.wlSetEmptyStringAll = new Label((Composite)wAllFields, 131072);
        this.wlSetEmptyStringAll.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.SetEmptyStringAll.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSetEmptyStringAll);
        FormData fdlSetEmptyStringAll = new FormData();
        fdlSetEmptyStringAll.left = new FormAttachment(0, 0);
        fdlSetEmptyStringAll.top = new FormAttachment((Control)this.wReplaceByValue, this.margin);
        fdlSetEmptyStringAll.right = new FormAttachment(middle, -this.margin);
        this.wlSetEmptyStringAll.setLayoutData((Object)fdlSetEmptyStringAll);
        this.wSetEmptyStringAll = new Button((Composite)wAllFields, 32);
        this.wSetEmptyStringAll.setToolTipText(BaseMessages.getString(PKG, (String)"IfNullDialog.SetEmptyStringAll.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSetEmptyStringAll);
        FormData fdSetEmptyStringAll = new FormData();
        fdSetEmptyStringAll.left = new FormAttachment(middle, 0);
        fdSetEmptyStringAll.top = new FormAttachment((Control)this.wlSetEmptyStringAll, 0, 0x1000000);
        fdSetEmptyStringAll.right = new FormAttachment(100, 0);
        this.wSetEmptyStringAll.setLayoutData((Object)fdSetEmptyStringAll);
        this.wSetEmptyStringAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IfNullDialog.this.input.setChanged();
                IfNullDialog.this.enableSetEmptyStringAll();
            }
        });
        this.wlMask = new Label((Composite)wAllFields, 131072);
        this.wlMask.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.Mask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlMask);
        FormData fdlMask = new FormData();
        fdlMask.left = new FormAttachment(0, 0);
        fdlMask.top = new FormAttachment((Control)this.wSetEmptyStringAll, this.margin);
        fdlMask.right = new FormAttachment(middle, -this.margin);
        this.wlMask.setLayoutData((Object)fdlMask);
        this.wMask = new CCombo((Composite)wAllFields, 2056);
        this.wMask.setEditable(true);
        this.wMask.setItems(Const.getDateFormats());
        PropsUi.setLook((Widget)this.wMask);
        this.wMask.addModifyListener(lsMod);
        FormData fdMask = new FormData();
        fdMask.left = new FormAttachment(middle, 0);
        fdMask.top = new FormAttachment((Control)this.wSetEmptyStringAll, this.margin);
        fdMask.right = new FormAttachment(100, 0);
        this.wMask.setLayoutData((Object)fdMask);
        FormData fdAllFields = new FormData();
        fdAllFields.left = new FormAttachment(0, this.margin);
        fdAllFields.top = new FormAttachment((Control)this.wTransformName, this.margin);
        fdAllFields.right = new FormAttachment(100, -this.margin);
        wAllFields.setLayoutData((Object)fdAllFields);
        Label wlSelectFields = new Label((Composite)this.shell, 131072);
        wlSelectFields.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.SelectFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSelectFields);
        FormData fdlSelectFields = new FormData();
        fdlSelectFields.left = new FormAttachment(0, 0);
        fdlSelectFields.top = new FormAttachment((Control)wAllFields, this.margin);
        fdlSelectFields.right = new FormAttachment(middle, -this.margin);
        wlSelectFields.setLayoutData((Object)fdlSelectFields);
        this.wSelectFields = new Button((Composite)this.shell, 32);
        this.wSelectFields.setToolTipText(BaseMessages.getString(PKG, (String)"IfNullDialog.SelectFields.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSelectFields);
        FormData fdSelectFields = new FormData();
        fdSelectFields.left = new FormAttachment(middle, 0);
        fdSelectFields.top = new FormAttachment((Control)wlSelectFields, 0, 0x1000000);
        fdSelectFields.right = new FormAttachment(100, 0);
        this.wSelectFields.setLayoutData((Object)fdSelectFields);
        Label wlSelectValuesType = new Label((Composite)this.shell, 131072);
        wlSelectValuesType.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.SelectValuesType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSelectValuesType);
        FormData fdlSelectValuesType = new FormData();
        fdlSelectValuesType.left = new FormAttachment(0, 0);
        fdlSelectValuesType.top = new FormAttachment((Control)this.wSelectFields, this.margin);
        fdlSelectValuesType.right = new FormAttachment(middle, -this.margin);
        wlSelectValuesType.setLayoutData((Object)fdlSelectValuesType);
        this.wSelectValuesType = new Button((Composite)this.shell, 32);
        this.wSelectValuesType.setToolTipText(BaseMessages.getString(PKG, (String)"IfNullDialog.SelectValuesType.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wSelectValuesType);
        FormData fdSelectValuesType = new FormData();
        fdSelectValuesType.left = new FormAttachment(middle, 0);
        fdSelectValuesType.top = new FormAttachment((Control)wlSelectValuesType, 0, 0x1000000);
        fdSelectValuesType.right = new FormAttachment(100, 0);
        this.wSelectValuesType.setLayoutData((Object)fdSelectValuesType);
        this.wlValueTypes = new Label((Composite)this.shell, 0);
        this.wlValueTypes.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.ValueTypes.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlValueTypes);
        FormData fdlValueTypes = new FormData();
        fdlValueTypes.left = new FormAttachment(0, 0);
        fdlValueTypes.top = new FormAttachment((Control)this.wSelectValuesType, this.margin);
        this.wlValueTypes.setLayoutData((Object)fdlValueTypes);
        int valueTypesRows = this.input.getValueTypes().size();
        ColumnInfo[] colval = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.ValueType.Column", (String[])new String[0]), 2, IValueMeta.typeCodes), new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Value.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Value.ConversionMask", (String[])new String[0]), 2, Const.getDateFormats()), new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Value.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_NO, (String[])new String[0])})};
        colval[1].setUsingVariables(true);
        this.wValueTypes = new TableView(this.variables, (Composite)this.shell, 67586, colval, valueTypesRows, this.oldlsMod, this.props);
        FormData fdValueTypes = new FormData();
        fdValueTypes.left = new FormAttachment(0, 0);
        fdValueTypes.top = new FormAttachment((Control)this.wlValueTypes, this.margin);
        fdValueTypes.right = new FormAttachment(100, 0);
        fdValueTypes.bottom = new FormAttachment((Control)this.wlValueTypes, (int)(190.0 * this.props.getZoomFactor()));
        this.wValueTypes.setLayoutData((Object)fdValueTypes);
        this.getFirstData();
        this.addFields();
        this.wSelectValuesType.addListener(13, e -> {
            this.activeSelectValuesType();
            this.input.setChanged();
        });
        this.wSelectFields.addListener(13, e -> {
            this.activeSelectFields();
            this.input.setChanged();
        });
        this.getData();
        this.enableSetEmptyStringAll();
        this.activeSelectFields();
        this.activeSelectValuesType();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addFields() {
        int fieldsCols = 4;
        ColumnInfo[] colinf = new ColumnInfo[fieldsCols];
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"IfNullDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wValueTypes, this.margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Fieldname.Column", (String[])new String[0]), 2, new String[0], false);
        colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Value.Column", (String[])new String[0]), 1, false);
        colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Value.ConversionMask", (String[])new String[0]), 2, Const.getDateFormats());
        colinf[1].setUsingVariables(true);
        colinf[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"IfNullDialog.Value.SetEmptyString", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_NO, (String[])new String[0])});
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, this.fieldsRows, this.oldlsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.setComboValues();
        this.fieldColumns.add(colinf[0]);
    }

    private void activeSelectFields() {
        if (this.wSelectFields.getSelection()) {
            this.wSelectValuesType.setSelection(false);
            this.wlValueTypes.setEnabled(false);
            this.wValueTypes.setEnabled(false);
        }
        this.activeFields();
    }

    private void activeSelectValuesType() {
        if (this.wSelectValuesType.getSelection()) {
            this.wSelectFields.setSelection(false);
            this.wFields.setEnabled(false);
            this.wlFields.setEnabled(false);
        }
        this.activeFields();
    }

    private void activeFields() {
        this.wlFields.setEnabled(this.wSelectFields.getSelection());
        this.wFields.setEnabled(this.wSelectFields.getSelection());
        this.wGet.setEnabled(this.wSelectFields.getSelection());
        this.wlValueTypes.setEnabled(this.wSelectValuesType.getSelection());
        this.wValueTypes.setEnabled(this.wSelectValuesType.getSelection());
        this.wlReplaceByValue.setEnabled(!this.wSelectFields.getSelection() && !this.wSelectValuesType.getSelection());
        this.wReplaceByValue.setEnabled(!this.wSelectFields.getSelection() && !this.wSelectValuesType.getSelection());
        this.wlMask.setEnabled(!this.wSelectFields.getSelection() && !this.wSelectValuesType.getSelection());
        this.wMask.setEnabled(!this.wSelectFields.getSelection() && !this.wSelectValuesType.getSelection());
        this.wlSetEmptyStringAll.setEnabled(!this.wSelectFields.getSelection() && !this.wSelectValuesType.getSelection());
        this.wSetEmptyStringAll.setEnabled(!this.wSelectFields.getSelection() && !this.wSelectValuesType.getSelection());
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener insertListener = (tableItem, v) -> true;
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)insertListener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void setComboValues() {
        Runnable fieldLoader = () -> {
            try {
                this.prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            }
            catch (HopException e) {
                String msg = BaseMessages.getString(PKG, (String)"IfNullDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                this.logError(msg);
            }
            Object[] prevTransformFieldNames = this.prevFields.getFieldNames();
            if (prevTransformFieldNames != null) {
                Arrays.sort(prevTransformFieldNames);
                for (ColumnInfo colInfo : this.fieldColumns) {
                    if (colInfo == null) continue;
                    colInfo.setComboValues((String[])prevTransformFieldNames);
                }
            }
        };
        new Thread(fieldLoader).start();
    }

    public void getFirstData() {
        this.wSelectFields.setSelection(this.input.isSelectFields());
        this.wSelectValuesType.setSelection(this.input.isSelectValuesType());
    }

    public void getData() {
        TableItem ti;
        int i;
        if (this.input.getReplaceAllByValue() != null) {
            this.wReplaceByValue.setText(this.input.getReplaceAllByValue());
        }
        if (this.input.getReplaceAllMask() != null) {
            this.wMask.setText(this.input.getReplaceAllMask());
        }
        this.wSetEmptyStringAll.setSelection(this.input.isSetEmptyStringAll());
        this.wSelectFields.setSelection(this.input.isSelectFields());
        this.wSelectValuesType.setSelection(this.input.isSelectValuesType());
        Table table = this.wValueTypes.table;
        if (!this.input.getValueTypes().isEmpty()) {
            table.removeAll();
        }
        for (i = 0; i < this.input.getValueTypes().size(); ++i) {
            ValueType valueType = this.input.getValueTypes().get(i);
            ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            if (valueType.getName() != null) {
                ti.setText(1, valueType.getName());
            }
            if (valueType.getValue() != null) {
                ti.setText(2, valueType.getValue());
            }
            if (valueType.getMask() != null) {
                ti.setText(3, valueType.getMask());
            }
            ti.setText(4, valueType.isSetEmptyString() ? BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_NO, (String[])new String[0]));
        }
        this.wValueTypes.setRowNums();
        this.wValueTypes.removeEmptyRows();
        this.wValueTypes.optWidth(true);
        table = this.wFields.table;
        if (!this.input.getFields().isEmpty()) {
            table.removeAll();
        }
        for (i = 0; i < this.input.getFields().size(); ++i) {
            Field field = this.input.getFields().get(i);
            ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            if (field.getName() != null) {
                ti.setText(1, field.getName());
            }
            if (field.getValue() != null) {
                ti.setText(2, field.getValue());
            }
            if (field.getMask() != null) {
                ti.setText(3, field.getMask());
            }
            ti.setText(4, field.isSetEmptyString() ? BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]) : BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_NO, (String[])new String[0]));
        }
        this.wFields.setRowNums();
        this.wValueTypes.removeEmptyRows();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void enableSetEmptyStringAll() {
        this.wMask.setText("");
    }

    private void ok() {
        TableItem ti;
        int i;
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setSetEmptyStringAll(this.wSetEmptyStringAll.getSelection());
        if (this.wSetEmptyStringAll.getSelection()) {
            this.input.setReplaceAllByValue("");
            this.input.setReplaceAllMask("");
        } else {
            this.input.setReplaceAllByValue(this.wReplaceByValue.getText());
            this.input.setReplaceAllMask(this.wMask.getText());
        }
        this.input.setSelectFields(this.wSelectFields.getSelection());
        this.input.setSelectValuesType(this.wSelectValuesType.getSelection());
        int nrtypes = this.wValueTypes.nrNonEmpty();
        int nrFields = this.wFields.nrNonEmpty();
        this.input.getValueTypes().clear();
        for (i = 0; i < nrtypes; ++i) {
            ti = this.wValueTypes.getNonEmpty(i);
            ValueType valueType = new ValueType();
            valueType.setName(ti.getText(1));
            valueType.setSetEmptyString(BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(ti.getText(4)));
            if (valueType.isSetEmptyString()) {
                valueType.setValue("");
                valueType.setMask("");
            } else {
                valueType.setValue(ti.getText(2));
                valueType.setMask(ti.getText(3));
            }
            this.input.getValueTypes().add(valueType);
        }
        this.input.getFields().clear();
        for (i = 0; i < nrFields; ++i) {
            ti = this.wFields.getNonEmpty(i);
            Field field = new Field();
            field.setName(ti.getText(1));
            field.setSetEmptyString(BaseMessages.getString(PKG, (String)CONST_SYSTEM_COMBO_YES, (String[])new String[0]).equalsIgnoreCase(ti.getText(4)));
            if (field.isSetEmptyString()) {
                field.setValue("");
                field.setMask("");
            } else {
                field.setValue(ti.getText(2));
                field.setMask(ti.getText(3));
            }
            this.input.getFields().add(field);
        }
        this.dispose();
    }
}

