/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ClientGSIContext
implements AlignmentContext {
    private final LongAccumulator lastSeenStateId;
    private ByteString routerFederatedState;

    public ClientGSIContext() {
        this(new LongAccumulator(Math::max, Long.MIN_VALUE));
    }

    public ClientGSIContext(LongAccumulator lastSeenStateId) {
        this.lastSeenStateId = lastSeenStateId;
        this.routerFederatedState = null;
    }

    public long getLastSeenStateId() {
        return this.lastSeenStateId.get();
    }

    public boolean isCoordinatedCall(String protocolName, String method) {
        throw new UnsupportedOperationException("Client should not be checking uncoordinated call");
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
    }

    public synchronized void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        if (header.hasRouterFederatedState()) {
            this.routerFederatedState = ClientGSIContext.mergeRouterFederatedState(this.routerFederatedState, header.getRouterFederatedState());
        } else {
            this.lastSeenStateId.accumulate(header.getStateId());
        }
    }

    public static Map<String, Long> getRouterFederatedStateMap(ByteString byteString) {
        if (byteString != null) {
            try {
                HdfsProtos.RouterFederatedStateProto federatedState = HdfsProtos.RouterFederatedStateProto.parseFrom(byteString);
                return federatedState.getNamespaceStateIdsMap();
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return Collections.emptyMap();
    }

    public static ByteString mergeRouterFederatedState(ByteString state1, ByteString state2) {
        HashMap<String, Long> mapping1 = new HashMap<String, Long>(ClientGSIContext.getRouterFederatedStateMap(state1));
        Map<String, Long> mapping2 = ClientGSIContext.getRouterFederatedStateMap(state2);
        mapping2.forEach((k, v) -> {
            long localValue = mapping1.getOrDefault(k, 0L);
            mapping1.put((String)k, Math.max(v, localValue));
        });
        HdfsProtos.RouterFederatedStateProto.Builder federatedBuilder = HdfsProtos.RouterFederatedStateProto.newBuilder();
        mapping1.forEach(federatedBuilder::putNamespaceStateIds);
        return federatedBuilder.build().toByteString();
    }

    public synchronized void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
        if (this.lastSeenStateId.get() != Long.MIN_VALUE) {
            header.setStateId(this.lastSeenStateId.get());
        }
        if (this.routerFederatedState != null) {
            header.setRouterFederatedState(this.routerFederatedState);
        }
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
        return 0L;
    }

    @VisibleForTesting
    public ByteString getRouterFederatedState() {
        return this.routerFederatedState;
    }
}

