/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.PolicyType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GovernancePolicyAddFoldersDetails {
    @Nonnull
    protected final String governancePolicyId;
    @Nonnull
    protected final String name;
    @Nullable
    protected final PolicyType policyType;
    @Nullable
    protected final List<String> folders;

    public GovernancePolicyAddFoldersDetails(@Nonnull String governancePolicyId, @Nonnull String name, @Nullable PolicyType policyType, @Nullable List<String> folders) {
        if (governancePolicyId == null) {
            throw new IllegalArgumentException("Required value for 'governancePolicyId' is null");
        }
        this.governancePolicyId = governancePolicyId;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        this.policyType = policyType;
        if (folders != null) {
            for (String x : folders) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'folders' is null");
            }
        }
        this.folders = folders;
    }

    public GovernancePolicyAddFoldersDetails(@Nonnull String governancePolicyId, @Nonnull String name) {
        this(governancePolicyId, name, null, null);
    }

    @Nonnull
    public String getGovernancePolicyId() {
        return this.governancePolicyId;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public PolicyType getPolicyType() {
        return this.policyType;
    }

    @Nullable
    public List<String> getFolders() {
        return this.folders;
    }

    public static Builder newBuilder(String governancePolicyId, String name) {
        return new Builder(governancePolicyId, name);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.governancePolicyId, this.name, this.policyType, this.folders});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GovernancePolicyAddFoldersDetails other = (GovernancePolicyAddFoldersDetails)obj;
            return !(this.governancePolicyId != other.governancePolicyId && !this.governancePolicyId.equals(other.governancePolicyId) || this.name != other.name && !this.name.equals(other.name) || this.policyType != other.policyType && (this.policyType == null || !this.policyType.equals((Object)other.policyType)) || this.folders != other.folders && (this.folders == null || !this.folders.equals(other.folders)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GovernancePolicyAddFoldersDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GovernancePolicyAddFoldersDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("governance_policy_id");
            StoneSerializers.string().serialize(value.governancePolicyId, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            if (value.policyType != null) {
                g.writeFieldName("policy_type");
                StoneSerializers.nullable(PolicyType.Serializer.INSTANCE).serialize(value.policyType, g);
            }
            if (value.folders != null) {
                g.writeFieldName("folders");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.folders, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GovernancePolicyAddFoldersDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_folders;
            PolicyType f_policyType;
            String f_name;
            String f_governancePolicyId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_governancePolicyId = null;
                f_name = null;
                f_policyType = null;
                f_folders = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("governance_policy_id".equals(field)) {
                        f_governancePolicyId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("policy_type".equals(field)) {
                        f_policyType = StoneSerializers.nullable(PolicyType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("folders".equals(field)) {
                        f_folders = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_governancePolicyId == null) {
                    throw new JsonParseException(p, "Required field \"governance_policy_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GovernancePolicyAddFoldersDetails value = new GovernancePolicyAddFoldersDetails(f_governancePolicyId, f_name, f_policyType, f_folders);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String governancePolicyId;
        protected final String name;
        protected PolicyType policyType;
        protected List<String> folders;

        protected Builder(String governancePolicyId, String name) {
            if (governancePolicyId == null) {
                throw new IllegalArgumentException("Required value for 'governancePolicyId' is null");
            }
            this.governancePolicyId = governancePolicyId;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            this.policyType = null;
            this.folders = null;
        }

        public Builder withPolicyType(PolicyType policyType) {
            this.policyType = policyType;
            return this;
        }

        public Builder withFolders(List<String> folders) {
            if (folders != null) {
                for (String x : folders) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'folders' is null");
                }
            }
            this.folders = folders;
            return this;
        }

        public GovernancePolicyAddFoldersDetails build() {
            return new GovernancePolicyAddFoldersDetails(this.governancePolicyId, this.name, this.policyType, this.folders);
        }
    }
}

