/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.MemberAddV2Result;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class MembersAddLaunchV2Result {
    public static final MembersAddLaunchV2Result OTHER = new MembersAddLaunchV2Result().withTag(Tag.OTHER);
    private Tag _tag;
    private String asyncJobIdValue;
    private List<MemberAddV2Result> completeValue;

    private MembersAddLaunchV2Result() {
    }

    private MembersAddLaunchV2Result withTag(Tag _tag) {
        MembersAddLaunchV2Result result = new MembersAddLaunchV2Result();
        result._tag = _tag;
        return result;
    }

    private MembersAddLaunchV2Result withTagAndAsyncJobId(Tag _tag, String asyncJobIdValue) {
        MembersAddLaunchV2Result result = new MembersAddLaunchV2Result();
        result._tag = _tag;
        result.asyncJobIdValue = asyncJobIdValue;
        return result;
    }

    private MembersAddLaunchV2Result withTagAndComplete(Tag _tag, List<MemberAddV2Result> completeValue) {
        MembersAddLaunchV2Result result = new MembersAddLaunchV2Result();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAsyncJobId() {
        return this._tag == Tag.ASYNC_JOB_ID;
    }

    public static MembersAddLaunchV2Result asyncJobId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new MembersAddLaunchV2Result().withTagAndAsyncJobId(Tag.ASYNC_JOB_ID, value);
    }

    public String getAsyncJobIdValue() {
        if (this._tag != Tag.ASYNC_JOB_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.ASYNC_JOB_ID, but was Tag." + this._tag.name());
        }
        return this.asyncJobIdValue;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static MembersAddLaunchV2Result complete(List<MemberAddV2Result> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (MemberAddV2Result x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new MembersAddLaunchV2Result().withTagAndComplete(Tag.COMPLETE, value);
    }

    public List<MemberAddV2Result> getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.asyncJobIdValue, this.completeValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MembersAddLaunchV2Result) {
            MembersAddLaunchV2Result other = (MembersAddLaunchV2Result)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ASYNC_JOB_ID: {
                    return this.asyncJobIdValue == other.asyncJobIdValue || this.asyncJobIdValue.equals(other.asyncJobIdValue);
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MembersAddLaunchV2Result> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersAddLaunchV2Result value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ASYNC_JOB_ID: {
                    g.writeStartObject();
                    this.writeTag("async_job_id", g);
                    g.writeFieldName("async_job_id");
                    StoneSerializers.string().serialize(value.asyncJobIdValue, g);
                    g.writeEndObject();
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    this.writeTag("complete", g);
                    g.writeFieldName("complete");
                    StoneSerializers.list(MemberAddV2Result.Serializer.INSTANCE).serialize((List<MemberAddV2Result>)value.completeValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MembersAddLaunchV2Result deserialize(JsonParser p) throws IOException, JsonParseException {
            MembersAddLaunchV2Result value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("async_job_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("async_job_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MembersAddLaunchV2Result.asyncJobId(fieldValue);
            } else if ("complete".equals(tag)) {
                List<MemberAddV2Result> fieldValue = null;
                Serializer.expectField("complete", p);
                fieldValue = StoneSerializers.list(MemberAddV2Result.Serializer.INSTANCE).deserialize(p);
                value = MembersAddLaunchV2Result.complete(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ASYNC_JOB_ID,
        COMPLETE,
        OTHER;

    }
}

