/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.RequestedLinkAccessLevel;
import com.dropbox.core.v2.sharing.RequestedVisibility;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Nullable;

public class SharedLinkSettings {
    @Nullable
    protected final Boolean requirePassword;
    @Nullable
    protected final String linkPassword;
    @Nullable
    protected final Date expires;
    @Nullable
    protected final LinkAudience audience;
    @Nullable
    protected final RequestedLinkAccessLevel access;
    @Nullable
    protected final RequestedVisibility requestedVisibility;
    @Nullable
    protected final Boolean allowDownload;

    public SharedLinkSettings(@Nullable Boolean requirePassword, @Nullable String linkPassword, @Nullable Date expires, @Nullable LinkAudience audience, @Nullable RequestedLinkAccessLevel access, @Nullable RequestedVisibility requestedVisibility, @Nullable Boolean allowDownload) {
        this.requirePassword = requirePassword;
        this.linkPassword = linkPassword;
        this.expires = LangUtil.truncateMillis(expires);
        this.audience = audience;
        this.access = access;
        this.requestedVisibility = requestedVisibility;
        this.allowDownload = allowDownload;
    }

    public SharedLinkSettings() {
        this(null, null, null, null, null, null, null);
    }

    @Nullable
    public Boolean getRequirePassword() {
        return this.requirePassword;
    }

    @Nullable
    public String getLinkPassword() {
        return this.linkPassword;
    }

    @Nullable
    public Date getExpires() {
        return this.expires;
    }

    @Nullable
    public LinkAudience getAudience() {
        return this.audience;
    }

    @Nullable
    public RequestedLinkAccessLevel getAccess() {
        return this.access;
    }

    @Nullable
    public RequestedVisibility getRequestedVisibility() {
        return this.requestedVisibility;
    }

    @Nullable
    public Boolean getAllowDownload() {
        return this.allowDownload;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.requirePassword, this.linkPassword, this.expires, this.audience, this.access, this.requestedVisibility, this.allowDownload});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedLinkSettings other = (SharedLinkSettings)obj;
            return (this.requirePassword == other.requirePassword || this.requirePassword != null && this.requirePassword.equals(other.requirePassword)) && (this.linkPassword == other.linkPassword || this.linkPassword != null && this.linkPassword.equals(other.linkPassword)) && (this.expires == other.expires || this.expires != null && this.expires.equals(other.expires)) && (this.audience == other.audience || this.audience != null && this.audience.equals((Object)other.audience)) && (this.access == other.access || this.access != null && this.access.equals((Object)other.access)) && (this.requestedVisibility == other.requestedVisibility || this.requestedVisibility != null && this.requestedVisibility.equals((Object)other.requestedVisibility)) && (this.allowDownload == other.allowDownload || this.allowDownload != null && this.allowDownload.equals(other.allowDownload));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedLinkSettings> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedLinkSettings value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.requirePassword != null) {
                g.writeFieldName("require_password");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.requirePassword, g);
            }
            if (value.linkPassword != null) {
                g.writeFieldName("link_password");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.linkPassword, g);
            }
            if (value.expires != null) {
                g.writeFieldName("expires");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expires, g);
            }
            if (value.audience != null) {
                g.writeFieldName("audience");
                StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).serialize(value.audience, g);
            }
            if (value.access != null) {
                g.writeFieldName("access");
                StoneSerializers.nullable(RequestedLinkAccessLevel.Serializer.INSTANCE).serialize(value.access, g);
            }
            if (value.requestedVisibility != null) {
                g.writeFieldName("requested_visibility");
                StoneSerializers.nullable(RequestedVisibility.Serializer.INSTANCE).serialize(value.requestedVisibility, g);
            }
            if (value.allowDownload != null) {
                g.writeFieldName("allow_download");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.allowDownload, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedLinkSettings deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_allowDownload;
            RequestedVisibility f_requestedVisibility;
            RequestedLinkAccessLevel f_access;
            LinkAudience f_audience;
            Date f_expires;
            String f_linkPassword;
            Boolean f_requirePassword;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_requirePassword = null;
                f_linkPassword = null;
                f_expires = null;
                f_audience = null;
                f_access = null;
                f_requestedVisibility = null;
                f_allowDownload = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("require_password".equals(field)) {
                        f_requirePassword = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    if ("link_password".equals(field)) {
                        f_linkPassword = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("expires".equals(field)) {
                        f_expires = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("audience".equals(field)) {
                        f_audience = StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("access".equals(field)) {
                        f_access = StoneSerializers.nullable(RequestedLinkAccessLevel.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("requested_visibility".equals(field)) {
                        f_requestedVisibility = StoneSerializers.nullable(RequestedVisibility.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("allow_download".equals(field)) {
                        f_allowDownload = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedLinkSettings value = new SharedLinkSettings(f_requirePassword, f_linkPassword, f_expires, f_audience, f_access, f_requestedVisibility, f_allowDownload);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected Boolean requirePassword = null;
        protected String linkPassword = null;
        protected Date expires = null;
        protected LinkAudience audience = null;
        protected RequestedLinkAccessLevel access = null;
        protected RequestedVisibility requestedVisibility = null;
        protected Boolean allowDownload = null;

        protected Builder() {
        }

        public Builder withRequirePassword(Boolean requirePassword) {
            this.requirePassword = requirePassword;
            return this;
        }

        public Builder withLinkPassword(String linkPassword) {
            this.linkPassword = linkPassword;
            return this;
        }

        public Builder withExpires(Date expires) {
            this.expires = LangUtil.truncateMillis(expires);
            return this;
        }

        public Builder withAudience(LinkAudience audience) {
            this.audience = audience;
            return this;
        }

        public Builder withAccess(RequestedLinkAccessLevel access) {
            this.access = access;
            return this;
        }

        public Builder withRequestedVisibility(RequestedVisibility requestedVisibility) {
            this.requestedVisibility = requestedVisibility;
            return this;
        }

        public Builder withAllowDownload(Boolean allowDownload) {
            this.allowDownload = allowDownload;
            return this;
        }

        public SharedLinkSettings build() {
            return new SharedLinkSettings(this.requirePassword, this.linkPassword, this.expires, this.audience, this.access, this.requestedVisibility, this.allowDownload);
        }
    }
}

