/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class ListTemplateResult {
    @Nonnull
    protected final List<String> templateIds;

    public ListTemplateResult(@Nonnull List<String> templateIds) {
        if (templateIds == null) {
            throw new IllegalArgumentException("Required value for 'templateIds' is null");
        }
        for (String x : templateIds) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'templateIds' is null");
            }
            if (x.length() < 1) {
                throw new IllegalArgumentException("Stringan item in list 'templateIds' is shorter than 1");
            }
            if (Pattern.matches("(/|ptid:).*", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'templateIds' does not match pattern");
        }
        this.templateIds = templateIds;
    }

    @Nonnull
    public List<String> getTemplateIds() {
        return this.templateIds;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.templateIds});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListTemplateResult other = (ListTemplateResult)obj;
            return this.templateIds == other.templateIds || this.templateIds.equals(other.templateIds);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<ListTemplateResult> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(ListTemplateResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("template_ids");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.templateIds, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListTemplateResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_templateIds;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_templateIds = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("template_ids".equals(field)) {
                        f_templateIds = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_templateIds == null) {
                    throw new JsonParseException(p, "Required field \"template_ids\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListTemplateResult value = new ListTemplateResult(f_templateIds);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

