/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.common;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.common.RootInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class PathRootError {
    public static final PathRootError NO_PERMISSION = new PathRootError().withTag(Tag.NO_PERMISSION);
    public static final PathRootError OTHER = new PathRootError().withTag(Tag.OTHER);
    private Tag _tag;
    private RootInfo invalidRootValue;

    private PathRootError() {
    }

    private PathRootError withTag(Tag _tag) {
        PathRootError result = new PathRootError();
        result._tag = _tag;
        return result;
    }

    private PathRootError withTagAndInvalidRoot(Tag _tag, RootInfo invalidRootValue) {
        PathRootError result = new PathRootError();
        result._tag = _tag;
        result.invalidRootValue = invalidRootValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInvalidRoot() {
        return this._tag == Tag.INVALID_ROOT;
    }

    public static PathRootError invalidRoot(RootInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new PathRootError().withTagAndInvalidRoot(Tag.INVALID_ROOT, value);
    }

    public RootInfo getInvalidRootValue() {
        if (this._tag != Tag.INVALID_ROOT) {
            throw new IllegalStateException("Invalid tag: required Tag.INVALID_ROOT, but was Tag." + this._tag.name());
        }
        return this.invalidRootValue;
    }

    public boolean isNoPermission() {
        return this._tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.invalidRootValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PathRootError) {
            PathRootError other = (PathRootError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case INVALID_ROOT: {
                    return this.invalidRootValue == other.invalidRootValue || this.invalidRootValue.equals(other.invalidRootValue);
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<PathRootError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(PathRootError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INVALID_ROOT: {
                    g.writeStartObject();
                    this.writeTag("invalid_root", g);
                    g.writeFieldName("invalid_root");
                    RootInfo.Serializer.INSTANCE.serialize(value.invalidRootValue, g);
                    g.writeEndObject();
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public PathRootError deserialize(JsonParser p) throws IOException, JsonParseException {
            PathRootError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("invalid_root".equals(tag)) {
                RootInfo fieldValue = null;
                Serializer.expectField("invalid_root", p);
                fieldValue = (RootInfo)RootInfo.Serializer.INSTANCE.deserialize(p);
                value = PathRootError.invalidRoot(fieldValue);
            } else {
                value = "no_permission".equals(tag) ? NO_PERMISSION : OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        INVALID_ROOT,
        NO_PERMISSION,
        OTHER;

    }
}

