/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2;

public class DbxPathV2 {
    public static boolean isValid(String path) {
        String error = DbxPathV2.findError(path);
        return error == null;
    }

    public static String findError(String path) {
        if (path.length() == 0) {
            return null;
        }
        if (!path.startsWith("/")) {
            return "expecting first character to be \"/\"";
        }
        if (path.endsWith("/")) {
            return "must not end with \"/\"";
        }
        return null;
    }

    public static String getName(String path) {
        if (path == null) {
            throw new IllegalArgumentException("'path' can't be null");
        }
        if (path.length() == 0) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Not a valid path.  Doesn't start with a \"/\": \"" + path + "\"");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Not a valid path.  Ends with a \"/\": \"" + path + "\"");
        }
        int start = path.length() - 1;
        while (path.charAt(start) != '/') {
            --start;
        }
        return path.substring(start + 1);
    }

    public static String[] split(String path) {
        if (path == null) {
            throw new IllegalArgumentException("'path' can't be null");
        }
        if (path.length() == 0) {
            return new String[0];
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Not a valid path.  Doesn't start with a \"/\": \"" + path + "\"");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Not a valid path.  Ends with a \"/\": \"" + path + "\"");
        }
        return path.substring(1).split("/");
    }

    public static String getParent(String path) {
        if (path == null) {
            throw new IllegalArgumentException("'path' can't be null");
        }
        if (path.length() == 0) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Not a valid path.  Doesn't start with a \"/\": \"" + path + "\"");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Not a valid path.  Ends with a \"/\": \"" + path + "\"");
        }
        int lastSlash = path.lastIndexOf("/");
        return path.substring(0, lastSlash);
    }
}

