/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.config.DescribedVariablesConfigFile;
import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.variables.DescribedVariable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.ui.hopgui.search.HopGuiDescribedVariableSearchable;
import org.apache.hop.ui.hopgui.search.HopGuiMetadataSearchable;
import org.apache.hop.ui.hopgui.search.HopGuiPipelineSearchable;
import org.apache.hop.ui.hopgui.search.HopGuiWorkflowSearchable;
import org.apache.hop.workflow.WorkflowMeta;

public class ProjectSearchablesIterator
implements Iterator<ISearchable> {
    private ProjectConfig projectConfig;
    private List<ISearchable> searchables;
    private Iterator<ISearchable> iterator;

    public ProjectSearchablesIterator(IHopMetadataProvider metadataProvider, IVariables variables, ProjectConfig projectConfig) throws HopException {
        this.projectConfig = projectConfig;
        this.searchables = new ArrayList<ISearchable>();
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        try {
            ArrayList<String> configurationFiles = new ArrayList<String>();
            List<LifecycleEnvironment> environments = config.findEnvironmentsOfProject(projectConfig.getProjectName());
            if (!environments.isEmpty()) {
                configurationFiles.addAll(environments.get(0).getConfigurationFiles());
            }
            FileObject homeFolderFile = HopVfs.getFileObject((String)projectConfig.getProjectHome());
            List pipelineFiles = HopVfs.findFiles((FileObject)homeFolderFile, (String)"hpl", (boolean)true);
            for (Object pipelineFile : pipelineFiles) {
                String pipelineFilePath = pipelineFile.getName().getURI();
                try {
                    PipelineMeta pipelineMeta = new PipelineMeta(pipelineFilePath, metadataProvider, variables);
                    this.searchables.add((ISearchable)new HopGuiPipelineSearchable("Project pipeline file", pipelineMeta));
                }
                catch (Exception e) {
                    LogChannel.GENERAL.logError("Error loading pipeline metadata: " + pipelineFilePath, (Throwable)e);
                }
            }
            List workflowFiles = HopVfs.findFiles((FileObject)homeFolderFile, (String)"hwf", (boolean)true);
            for (FileObject workflowFile : workflowFiles) {
                String workflowFilePath = workflowFile.getName().getURI();
                try {
                    WorkflowMeta workflowMeta = new WorkflowMeta(variables, workflowFilePath, metadataProvider);
                    this.searchables.add((ISearchable)new HopGuiWorkflowSearchable("Project workflow file", workflowMeta));
                }
                catch (Exception e) {
                    LogChannel.GENERAL.logError("Error loading workflow metadata: " + workflowFilePath, (Throwable)e);
                }
            }
            for (Class metadataClass : metadataProvider.getMetadataClasses()) {
                IHopMetadataSerializer serializer = metadataProvider.getSerializer(metadataClass);
                for (String metadataName : serializer.listObjectNames()) {
                    IHopMetadata hopMetadata = serializer.load(metadataName);
                    HopGuiMetadataSearchable searchable = new HopGuiMetadataSearchable(metadataProvider, serializer, hopMetadata, serializer.getManagedClass());
                    this.searchables.add((ISearchable)searchable);
                }
            }
            List describedVariables = HopConfig.getInstance().getDescribedVariables();
            for (DescribedVariable describedVariable : describedVariables) {
                this.searchables.add((ISearchable)new HopGuiDescribedVariableSearchable(describedVariable, null));
            }
            for (String configurationFile : configurationFiles) {
                String realConfigurationFile = variables.resolve(configurationFile);
                if (!HopVfs.fileExists((String)realConfigurationFile)) continue;
                DescribedVariablesConfigFile configFile = new DescribedVariablesConfigFile(realConfigurationFile);
                configFile.readFromFile();
                for (DescribedVariable describedVariable : configFile.getDescribedVariables()) {
                    this.searchables.add((ISearchable)new HopGuiDescribedVariableSearchable(describedVariable, configurationFile));
                }
            }
            this.iterator = this.searchables.iterator();
        }
        catch (Exception e) {
            throw new HopException("Error loading list of project '" + projectConfig.getProjectName() + "' searchables", (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public ISearchable next() {
        return this.iterator.next();
    }
}

