/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.util.stream.IntStream;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.factory.stack.primitive.ImmutableIntStackFactory;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntArrayStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntEmptyStack;
import org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntSingletonStack;

public class ImmutableIntStackFactoryImpl
implements ImmutableIntStackFactory {
    public static final ImmutableIntStackFactory INSTANCE = new ImmutableIntStackFactoryImpl();

    public ImmutableIntStack empty() {
        return ImmutableIntEmptyStack.INSTANCE;
    }

    public ImmutableIntStack of() {
        return this.empty();
    }

    public ImmutableIntStack with() {
        return this.empty();
    }

    public ImmutableIntStack of(int one) {
        return this.with(one);
    }

    public ImmutableIntStack with(int one) {
        return new ImmutableIntSingletonStack(one);
    }

    public ImmutableIntStack of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntStack with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntArrayStack.newStackWith(items);
    }

    public ImmutableIntStack ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntStack withAll(IntIterable items) {
        if (items instanceof ImmutableIntStack) {
            return (ImmutableIntStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableIntStack ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    public ImmutableIntStack withAll(Iterable<Integer> iterable) {
        return IntStacks.mutable.withAll(iterable).toImmutable();
    }

    public ImmutableIntStack ofAllReversed(IntIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableIntStack withAllReversed(IntIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableIntArrayStack.newStackFromTopToBottom(items);
    }

    public ImmutableIntStack ofAll(IntStream items) {
        return this.withAll(items);
    }

    public ImmutableIntStack withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

