/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.stream.DoubleStream;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.factory.set.primitive.MutableDoubleSetFactory;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.factory.primitive.DoubleSets;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableDoubleSetFactoryImpl
implements MutableDoubleSetFactory {
    public static final MutableDoubleSetFactory INSTANCE = new MutableDoubleSetFactoryImpl();

    public MutableDoubleSet empty() {
        return new DoubleHashSet();
    }

    public MutableDoubleSet of() {
        return this.empty();
    }

    public MutableDoubleSet with() {
        return this.empty();
    }

    public MutableDoubleSet withInitialCapacity(int capacity) {
        return new DoubleHashSet(capacity);
    }

    public MutableDoubleSet of(double ... items) {
        return this.with(items);
    }

    public MutableDoubleSet with(double ... items) {
        if (items == null || items.length == 0) {
            return this.empty();
        }
        return DoubleHashSet.newSetWith(items);
    }

    public MutableDoubleSet ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public MutableDoubleSet withAll(DoubleIterable items) {
        return DoubleHashSet.newSet(items);
    }

    public MutableDoubleSet ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    public MutableDoubleSet withAll(Iterable<Double> iterable) {
        return Iterate.collectDouble(iterable, Double::doubleValue, DoubleSets.mutable.empty());
    }

    public MutableDoubleSet ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    public MutableDoubleSet withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

